/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelemetryRecord implements SdkPojo, Serializable, ToCopyableBuilder<TelemetryRecord.Builder, TelemetryRecord> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(TelemetryRecord::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<Integer> SEGMENTS_RECEIVED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentsReceivedCount").getter(getter(TelemetryRecord::segmentsReceivedCount))
            .setter(setter(Builder::segmentsReceivedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentsReceivedCount").build())
            .build();

    private static final SdkField<Integer> SEGMENTS_SENT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentsSentCount").getter(getter(TelemetryRecord::segmentsSentCount))
            .setter(setter(Builder::segmentsSentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentsSentCount").build()).build();

    private static final SdkField<Integer> SEGMENTS_SPILLOVER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentsSpilloverCount").getter(getter(TelemetryRecord::segmentsSpilloverCount))
            .setter(setter(Builder::segmentsSpilloverCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentsSpilloverCount").build())
            .build();

    private static final SdkField<Integer> SEGMENTS_REJECTED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentsRejectedCount").getter(getter(TelemetryRecord::segmentsRejectedCount))
            .setter(setter(Builder::segmentsRejectedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentsRejectedCount").build())
            .build();

    private static final SdkField<BackendConnectionErrors> BACKEND_CONNECTION_ERRORS_FIELD = SdkField
            .<BackendConnectionErrors> builder(MarshallingType.SDK_POJO).memberName("BackendConnectionErrors")
            .getter(getter(TelemetryRecord::backendConnectionErrors)).setter(setter(Builder::backendConnectionErrors))
            .constructor(BackendConnectionErrors::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackendConnectionErrors").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            SEGMENTS_RECEIVED_COUNT_FIELD, SEGMENTS_SENT_COUNT_FIELD, SEGMENTS_SPILLOVER_COUNT_FIELD,
            SEGMENTS_REJECTED_COUNT_FIELD, BACKEND_CONNECTION_ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final Integer segmentsReceivedCount;

    private final Integer segmentsSentCount;

    private final Integer segmentsSpilloverCount;

    private final Integer segmentsRejectedCount;

    private final BackendConnectionErrors backendConnectionErrors;

    private TelemetryRecord(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.segmentsReceivedCount = builder.segmentsReceivedCount;
        this.segmentsSentCount = builder.segmentsSentCount;
        this.segmentsSpilloverCount = builder.segmentsSpilloverCount;
        this.segmentsRejectedCount = builder.segmentsRejectedCount;
        this.backendConnectionErrors = builder.backendConnectionErrors;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Integer segmentsReceivedCount() {
        return segmentsReceivedCount;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Integer segmentsSentCount() {
        return segmentsSentCount;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Integer segmentsSpilloverCount() {
        return segmentsSpilloverCount;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Integer segmentsRejectedCount() {
        return segmentsRejectedCount;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final BackendConnectionErrors backendConnectionErrors() {
        return backendConnectionErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(segmentsReceivedCount());
        hashCode = 31 * hashCode + Objects.hashCode(segmentsSentCount());
        hashCode = 31 * hashCode + Objects.hashCode(segmentsSpilloverCount());
        hashCode = 31 * hashCode + Objects.hashCode(segmentsRejectedCount());
        hashCode = 31 * hashCode + Objects.hashCode(backendConnectionErrors());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryRecord)) {
            return false;
        }
        TelemetryRecord other = (TelemetryRecord) obj;
        return Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(segmentsReceivedCount(), other.segmentsReceivedCount())
                && Objects.equals(segmentsSentCount(), other.segmentsSentCount())
                && Objects.equals(segmentsSpilloverCount(), other.segmentsSpilloverCount())
                && Objects.equals(segmentsRejectedCount(), other.segmentsRejectedCount())
                && Objects.equals(backendConnectionErrors(), other.backendConnectionErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TelemetryRecord").add("Timestamp", timestamp())
                .add("SegmentsReceivedCount", segmentsReceivedCount()).add("SegmentsSentCount", segmentsSentCount())
                .add("SegmentsSpilloverCount", segmentsSpilloverCount()).add("SegmentsRejectedCount", segmentsRejectedCount())
                .add("BackendConnectionErrors", backendConnectionErrors()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "SegmentsReceivedCount":
            return Optional.ofNullable(clazz.cast(segmentsReceivedCount()));
        case "SegmentsSentCount":
            return Optional.ofNullable(clazz.cast(segmentsSentCount()));
        case "SegmentsSpilloverCount":
            return Optional.ofNullable(clazz.cast(segmentsSpilloverCount()));
        case "SegmentsRejectedCount":
            return Optional.ofNullable(clazz.cast(segmentsRejectedCount()));
        case "BackendConnectionErrors":
            return Optional.ofNullable(clazz.cast(backendConnectionErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TelemetryRecord, T> g) {
        return obj -> g.apply((TelemetryRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelemetryRecord> {
        /**
         * <p/>
         * 
         * @param timestamp
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p/>
         * 
         * @param segmentsReceivedCount
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentsReceivedCount(Integer segmentsReceivedCount);

        /**
         * <p/>
         * 
         * @param segmentsSentCount
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentsSentCount(Integer segmentsSentCount);

        /**
         * <p/>
         * 
         * @param segmentsSpilloverCount
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentsSpilloverCount(Integer segmentsSpilloverCount);

        /**
         * <p/>
         * 
         * @param segmentsRejectedCount
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentsRejectedCount(Integer segmentsRejectedCount);

        /**
         * <p/>
         * 
         * @param backendConnectionErrors
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendConnectionErrors(BackendConnectionErrors backendConnectionErrors);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link BackendConnectionErrors.Builder} avoiding
         * the need to create one manually via {@link BackendConnectionErrors#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackendConnectionErrors.Builder#build()} is called immediately
         * and its result is passed to {@link #backendConnectionErrors(BackendConnectionErrors)}.
         * 
         * @param backendConnectionErrors
         *        a consumer that will call methods on {@link BackendConnectionErrors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backendConnectionErrors(BackendConnectionErrors)
         */
        default Builder backendConnectionErrors(Consumer<BackendConnectionErrors.Builder> backendConnectionErrors) {
            return backendConnectionErrors(BackendConnectionErrors.builder().applyMutation(backendConnectionErrors).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private Integer segmentsReceivedCount;

        private Integer segmentsSentCount;

        private Integer segmentsSpilloverCount;

        private Integer segmentsRejectedCount;

        private BackendConnectionErrors backendConnectionErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryRecord model) {
            timestamp(model.timestamp);
            segmentsReceivedCount(model.segmentsReceivedCount);
            segmentsSentCount(model.segmentsSentCount);
            segmentsSpilloverCount(model.segmentsSpilloverCount);
            segmentsRejectedCount(model.segmentsRejectedCount);
            backendConnectionErrors(model.backendConnectionErrors);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Integer getSegmentsReceivedCount() {
            return segmentsReceivedCount;
        }

        public final void setSegmentsReceivedCount(Integer segmentsReceivedCount) {
            this.segmentsReceivedCount = segmentsReceivedCount;
        }

        @Override
        public final Builder segmentsReceivedCount(Integer segmentsReceivedCount) {
            this.segmentsReceivedCount = segmentsReceivedCount;
            return this;
        }

        public final Integer getSegmentsSentCount() {
            return segmentsSentCount;
        }

        public final void setSegmentsSentCount(Integer segmentsSentCount) {
            this.segmentsSentCount = segmentsSentCount;
        }

        @Override
        public final Builder segmentsSentCount(Integer segmentsSentCount) {
            this.segmentsSentCount = segmentsSentCount;
            return this;
        }

        public final Integer getSegmentsSpilloverCount() {
            return segmentsSpilloverCount;
        }

        public final void setSegmentsSpilloverCount(Integer segmentsSpilloverCount) {
            this.segmentsSpilloverCount = segmentsSpilloverCount;
        }

        @Override
        public final Builder segmentsSpilloverCount(Integer segmentsSpilloverCount) {
            this.segmentsSpilloverCount = segmentsSpilloverCount;
            return this;
        }

        public final Integer getSegmentsRejectedCount() {
            return segmentsRejectedCount;
        }

        public final void setSegmentsRejectedCount(Integer segmentsRejectedCount) {
            this.segmentsRejectedCount = segmentsRejectedCount;
        }

        @Override
        public final Builder segmentsRejectedCount(Integer segmentsRejectedCount) {
            this.segmentsRejectedCount = segmentsRejectedCount;
            return this;
        }

        public final BackendConnectionErrors.Builder getBackendConnectionErrors() {
            return backendConnectionErrors != null ? backendConnectionErrors.toBuilder() : null;
        }

        public final void setBackendConnectionErrors(BackendConnectionErrors.BuilderImpl backendConnectionErrors) {
            this.backendConnectionErrors = backendConnectionErrors != null ? backendConnectionErrors.build() : null;
        }

        @Override
        public final Builder backendConnectionErrors(BackendConnectionErrors backendConnectionErrors) {
            this.backendConnectionErrors = backendConnectionErrors;
            return this;
        }

        @Override
        public TelemetryRecord build() {
            return new TelemetryRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
