/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGroupRequest extends XRayRequest implements
        ToCopyableBuilder<UpdateGroupRequest.Builder, UpdateGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(UpdateGroupRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupARN").getter(getter(UpdateGroupRequest::groupARN)).setter(setter(Builder::groupARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupARN").build()).build();

    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterExpression").getter(getter(UpdateGroupRequest::filterExpression))
            .setter(setter(Builder::filterExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()).build();

    private static final SdkField<InsightsConfiguration> INSIGHTS_CONFIGURATION_FIELD = SdkField
            .<InsightsConfiguration> builder(MarshallingType.SDK_POJO).memberName("InsightsConfiguration")
            .getter(getter(UpdateGroupRequest::insightsConfiguration)).setter(setter(Builder::insightsConfiguration))
            .constructor(InsightsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightsConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            GROUP_ARN_FIELD, FILTER_EXPRESSION_FIELD, INSIGHTS_CONFIGURATION_FIELD));

    private final String groupName;

    private final String groupARN;

    private final String filterExpression;

    private final InsightsConfiguration insightsConfiguration;

    private UpdateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.groupARN = builder.groupARN;
        this.filterExpression = builder.filterExpression;
        this.insightsConfiguration = builder.insightsConfiguration;
    }

    /**
     * <p>
     * The case-sensitive name of the group.
     * </p>
     * 
     * @return The case-sensitive name of the group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The ARN that was generated upon creation.
     * </p>
     * 
     * @return The ARN that was generated upon creation.
     */
    public final String groupARN() {
        return groupARN;
    }

    /**
     * <p>
     * The updated filter expression defining criteria by which to group traces.
     * </p>
     * 
     * @return The updated filter expression defining criteria by which to group traces.
     */
    public final String filterExpression() {
        return filterExpression;
    }

    /**
     * <p>
     * The structure containing configurations related to insights.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for
     * the group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group. Notifications
     * can only be enabled on a group with InsightsEnabled set to true.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The structure containing configurations related to insights.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable
     *         insights for the group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group.
     *         Notifications can only be enabled on a group with InsightsEnabled set to true.
     *         </p>
     *         </li>
     */
    public final InsightsConfiguration insightsConfiguration() {
        return insightsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupARN());
        hashCode = 31 * hashCode + Objects.hashCode(filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(insightsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest other = (UpdateGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(groupARN(), other.groupARN())
                && Objects.equals(filterExpression(), other.filterExpression())
                && Objects.equals(insightsConfiguration(), other.insightsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGroupRequest").add("GroupName", groupName()).add("GroupARN", groupARN())
                .add("FilterExpression", filterExpression()).add("InsightsConfiguration", insightsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "GroupARN":
            return Optional.ofNullable(clazz.cast(groupARN()));
        case "FilterExpression":
            return Optional.ofNullable(clazz.cast(filterExpression()));
        case "InsightsConfiguration":
            return Optional.ofNullable(clazz.cast(insightsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGroupRequest, T> g) {
        return obj -> g.apply((UpdateGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGroupRequest> {
        /**
         * <p>
         * The case-sensitive name of the group.
         * </p>
         * 
         * @param groupName
         *        The case-sensitive name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The ARN that was generated upon creation.
         * </p>
         * 
         * @param groupARN
         *        The ARN that was generated upon creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupARN(String groupARN);

        /**
         * <p>
         * The updated filter expression defining criteria by which to group traces.
         * </p>
         * 
         * @param filterExpression
         *        The updated filter expression defining criteria by which to group traces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpression(String filterExpression);

        /**
         * <p>
         * The structure containing configurations related to insights.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights
         * for the group.
         * </p>
         * </li>
         * <li>
         * <p>
         * The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group.
         * Notifications can only be enabled on a group with InsightsEnabled set to true.
         * </p>
         * </li>
         * </ul>
         * 
         * @param insightsConfiguration
         *        The structure containing configurations related to insights.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable
         *        insights for the group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group.
         *        Notifications can only be enabled on a group with InsightsEnabled set to true.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightsConfiguration(InsightsConfiguration insightsConfiguration);

        /**
         * <p>
         * The structure containing configurations related to insights.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights
         * for the group.
         * </p>
         * </li>
         * <li>
         * <p>
         * The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group.
         * Notifications can only be enabled on a group with InsightsEnabled set to true.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link InsightsConfiguration.Builder} avoiding
         * the need to create one manually via {@link InsightsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InsightsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #insightsConfiguration(InsightsConfiguration)}.
         * 
         * @param insightsConfiguration
         *        a consumer that will call methods on {@link InsightsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightsConfiguration(InsightsConfiguration)
         */
        default Builder insightsConfiguration(Consumer<InsightsConfiguration.Builder> insightsConfiguration) {
            return insightsConfiguration(InsightsConfiguration.builder().applyMutation(insightsConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private String groupName;

        private String groupARN;

        private String filterExpression;

        private InsightsConfiguration insightsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupRequest model) {
            super(model);
            groupName(model.groupName);
            groupARN(model.groupARN);
            filterExpression(model.filterExpression);
            insightsConfiguration(model.insightsConfiguration);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroupARN() {
            return groupARN;
        }

        public final void setGroupARN(String groupARN) {
            this.groupARN = groupARN;
        }

        @Override
        public final Builder groupARN(String groupARN) {
            this.groupARN = groupARN;
            return this;
        }

        public final String getFilterExpression() {
            return filterExpression;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final InsightsConfiguration.Builder getInsightsConfiguration() {
            return insightsConfiguration != null ? insightsConfiguration.toBuilder() : null;
        }

        public final void setInsightsConfiguration(InsightsConfiguration.BuilderImpl insightsConfiguration) {
            this.insightsConfiguration = insightsConfiguration != null ? insightsConfiguration.build() : null;
        }

        @Override
        public final Builder insightsConfiguration(InsightsConfiguration insightsConfiguration) {
            this.insightsConfiguration = insightsConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGroupRequest build() {
            return new UpdateGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
