/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a segment annotation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValueWithServiceIds implements SdkPojo, Serializable,
        ToCopyableBuilder<ValueWithServiceIds.Builder, ValueWithServiceIds> {
    private static final SdkField<AnnotationValue> ANNOTATION_VALUE_FIELD = SdkField
            .<AnnotationValue> builder(MarshallingType.SDK_POJO).memberName("AnnotationValue")
            .getter(getter(ValueWithServiceIds::annotationValue)).setter(setter(Builder::annotationValue))
            .constructor(AnnotationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationValue").build()).build();

    private static final SdkField<List<ServiceId>> SERVICE_IDS_FIELD = SdkField
            .<List<ServiceId>> builder(MarshallingType.LIST)
            .memberName("ServiceIds")
            .getter(getter(ValueWithServiceIds::serviceIds))
            .setter(setter(Builder::serviceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceId> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_VALUE_FIELD,
            SERVICE_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AnnotationValue annotationValue;

    private final List<ServiceId> serviceIds;

    private ValueWithServiceIds(BuilderImpl builder) {
        this.annotationValue = builder.annotationValue;
        this.serviceIds = builder.serviceIds;
    }

    /**
     * <p>
     * Values of the annotation.
     * </p>
     * 
     * @return Values of the annotation.
     */
    public final AnnotationValue annotationValue() {
        return annotationValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServiceIds() {
        return serviceIds != null && !(serviceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Services to which the annotation applies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceIds} method.
     * </p>
     * 
     * @return Services to which the annotation applies.
     */
    public final List<ServiceId> serviceIds() {
        return serviceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(annotationValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceIds() ? serviceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValueWithServiceIds)) {
            return false;
        }
        ValueWithServiceIds other = (ValueWithServiceIds) obj;
        return Objects.equals(annotationValue(), other.annotationValue()) && hasServiceIds() == other.hasServiceIds()
                && Objects.equals(serviceIds(), other.serviceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValueWithServiceIds").add("AnnotationValue", annotationValue())
                .add("ServiceIds", hasServiceIds() ? serviceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnnotationValue":
            return Optional.ofNullable(clazz.cast(annotationValue()));
        case "ServiceIds":
            return Optional.ofNullable(clazz.cast(serviceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValueWithServiceIds, T> g) {
        return obj -> g.apply((ValueWithServiceIds) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValueWithServiceIds> {
        /**
         * <p>
         * Values of the annotation.
         * </p>
         * 
         * @param annotationValue
         *        Values of the annotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationValue(AnnotationValue annotationValue);

        /**
         * <p>
         * Values of the annotation.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnnotationValue.Builder} avoiding the
         * need to create one manually via {@link AnnotationValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnnotationValue.Builder#build()} is called immediately and its
         * result is passed to {@link #annotationValue(AnnotationValue)}.
         * 
         * @param annotationValue
         *        a consumer that will call methods on {@link AnnotationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotationValue(AnnotationValue)
         */
        default Builder annotationValue(Consumer<AnnotationValue.Builder> annotationValue) {
            return annotationValue(AnnotationValue.builder().applyMutation(annotationValue).build());
        }

        /**
         * <p>
         * Services to which the annotation applies.
         * </p>
         * 
         * @param serviceIds
         *        Services to which the annotation applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIds(Collection<ServiceId> serviceIds);

        /**
         * <p>
         * Services to which the annotation applies.
         * </p>
         * 
         * @param serviceIds
         *        Services to which the annotation applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIds(ServiceId... serviceIds);

        /**
         * <p>
         * Services to which the annotation applies.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ServiceId>.Builder} avoiding the
         * need to create one manually via {@link List<ServiceId>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceId>.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceIds(List<ServiceId>)}.
         * 
         * @param serviceIds
         *        a consumer that will call methods on {@link List<ServiceId>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceIds(List<ServiceId>)
         */
        Builder serviceIds(Consumer<ServiceId.Builder>... serviceIds);
    }

    static final class BuilderImpl implements Builder {
        private AnnotationValue annotationValue;

        private List<ServiceId> serviceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValueWithServiceIds model) {
            annotationValue(model.annotationValue);
            serviceIds(model.serviceIds);
        }

        public final AnnotationValue.Builder getAnnotationValue() {
            return annotationValue != null ? annotationValue.toBuilder() : null;
        }

        public final void setAnnotationValue(AnnotationValue.BuilderImpl annotationValue) {
            this.annotationValue = annotationValue != null ? annotationValue.build() : null;
        }

        @Override
        public final Builder annotationValue(AnnotationValue annotationValue) {
            this.annotationValue = annotationValue;
            return this;
        }

        public final List<ServiceId.Builder> getServiceIds() {
            List<ServiceId.Builder> result = ServiceIdsCopier.copyToBuilder(this.serviceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceIds(Collection<ServiceId.BuilderImpl> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copyFromBuilder(serviceIds);
        }

        @Override
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(ServiceId... serviceIds) {
            serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(Consumer<ServiceId.Builder>... serviceIds) {
            serviceIds(Stream.of(serviceIds).map(c -> ServiceId.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ValueWithServiceIds build() {
            return new ValueWithServiceIds(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
