/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request sampling results for a single rule from a service. Results are for the last 10 seconds unless the service has
 * been assigned a longer reporting interval after a previous call to <a
 * href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamplingStatisticsDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<SamplingStatisticsDocument.Builder, SamplingStatisticsDocument> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(SamplingStatisticsDocument::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientID").getter(getter(SamplingStatisticsDocument::clientID)).setter(setter(Builder::clientID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientID").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(SamplingStatisticsDocument::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<Integer> REQUEST_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RequestCount").getter(getter(SamplingStatisticsDocument::requestCount))
            .setter(setter(Builder::requestCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestCount").build()).build();

    private static final SdkField<Integer> SAMPLED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampledCount").getter(getter(SamplingStatisticsDocument::sampledCount))
            .setter(setter(Builder::sampledCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledCount").build()).build();

    private static final SdkField<Integer> BORROW_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BorrowCount").getter(getter(SamplingStatisticsDocument::borrowCount))
            .setter(setter(Builder::borrowCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorrowCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            CLIENT_ID_FIELD, TIMESTAMP_FIELD, REQUEST_COUNT_FIELD, SAMPLED_COUNT_FIELD, BORROW_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleName;

    private final String clientID;

    private final Instant timestamp;

    private final Integer requestCount;

    private final Integer sampledCount;

    private final Integer borrowCount;

    private SamplingStatisticsDocument(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.clientID = builder.clientID;
        this.timestamp = builder.timestamp;
        this.requestCount = builder.requestCount;
        this.sampledCount = builder.sampledCount;
        this.borrowCount = builder.borrowCount;
    }

    /**
     * <p>
     * The name of the sampling rule.
     * </p>
     * 
     * @return The name of the sampling rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * A unique identifier for the service in hexadecimal.
     * </p>
     * 
     * @return A unique identifier for the service in hexadecimal.
     */
    public final String clientID() {
        return clientID;
    }

    /**
     * <p>
     * The current time.
     * </p>
     * 
     * @return The current time.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The number of requests that matched the rule.
     * </p>
     * 
     * @return The number of requests that matched the rule.
     */
    public final Integer requestCount() {
        return requestCount;
    }

    /**
     * <p>
     * The number of requests recorded.
     * </p>
     * 
     * @return The number of requests recorded.
     */
    public final Integer sampledCount() {
        return sampledCount;
    }

    /**
     * <p>
     * The number of requests recorded with borrowed reservoir quota.
     * </p>
     * 
     * @return The number of requests recorded with borrowed reservoir quota.
     */
    public final Integer borrowCount() {
        return borrowCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(clientID());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(requestCount());
        hashCode = 31 * hashCode + Objects.hashCode(sampledCount());
        hashCode = 31 * hashCode + Objects.hashCode(borrowCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingStatisticsDocument)) {
            return false;
        }
        SamplingStatisticsDocument other = (SamplingStatisticsDocument) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(clientID(), other.clientID())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(requestCount(), other.requestCount())
                && Objects.equals(sampledCount(), other.sampledCount()) && Objects.equals(borrowCount(), other.borrowCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SamplingStatisticsDocument").add("RuleName", ruleName()).add("ClientID", clientID())
                .add("Timestamp", timestamp()).add("RequestCount", requestCount()).add("SampledCount", sampledCount())
                .add("BorrowCount", borrowCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "ClientID":
            return Optional.ofNullable(clazz.cast(clientID()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "RequestCount":
            return Optional.ofNullable(clazz.cast(requestCount()));
        case "SampledCount":
            return Optional.ofNullable(clazz.cast(sampledCount()));
        case "BorrowCount":
            return Optional.ofNullable(clazz.cast(borrowCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SamplingStatisticsDocument, T> g) {
        return obj -> g.apply((SamplingStatisticsDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamplingStatisticsDocument> {
        /**
         * <p>
         * The name of the sampling rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the sampling rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * A unique identifier for the service in hexadecimal.
         * </p>
         * 
         * @param clientID
         *        A unique identifier for the service in hexadecimal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientID(String clientID);

        /**
         * <p>
         * The current time.
         * </p>
         * 
         * @param timestamp
         *        The current time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The number of requests that matched the rule.
         * </p>
         * 
         * @param requestCount
         *        The number of requests that matched the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestCount(Integer requestCount);

        /**
         * <p>
         * The number of requests recorded.
         * </p>
         * 
         * @param sampledCount
         *        The number of requests recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampledCount(Integer sampledCount);

        /**
         * <p>
         * The number of requests recorded with borrowed reservoir quota.
         * </p>
         * 
         * @param borrowCount
         *        The number of requests recorded with borrowed reservoir quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder borrowCount(Integer borrowCount);
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private String clientID;

        private Instant timestamp;

        private Integer requestCount;

        private Integer sampledCount;

        private Integer borrowCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingStatisticsDocument model) {
            ruleName(model.ruleName);
            clientID(model.clientID);
            timestamp(model.timestamp);
            requestCount(model.requestCount);
            sampledCount(model.sampledCount);
            borrowCount(model.borrowCount);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getClientID() {
            return clientID;
        }

        public final void setClientID(String clientID) {
            this.clientID = clientID;
        }

        @Override
        public final Builder clientID(String clientID) {
            this.clientID = clientID;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Integer getRequestCount() {
            return requestCount;
        }

        public final void setRequestCount(Integer requestCount) {
            this.requestCount = requestCount;
        }

        @Override
        public final Builder requestCount(Integer requestCount) {
            this.requestCount = requestCount;
            return this;
        }

        public final Integer getSampledCount() {
            return sampledCount;
        }

        public final void setSampledCount(Integer sampledCount) {
            this.sampledCount = sampledCount;
        }

        @Override
        public final Builder sampledCount(Integer sampledCount) {
            this.sampledCount = sampledCount;
            return this;
        }

        public final Integer getBorrowCount() {
            return borrowCount;
        }

        public final void setBorrowCount(Integer borrowCount) {
            this.borrowCount = borrowCount;
        }

        @Override
        public final Builder borrowCount(Integer borrowCount) {
            this.borrowCount = borrowCount;
            return this;
        }

        @Override
        public SamplingStatisticsDocument build() {
            return new SamplingStatisticsDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
