/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetTracesResponse extends XRayResponse implements
        ToCopyableBuilder<BatchGetTracesResponse.Builder, BatchGetTracesResponse> {
    private static final SdkField<List<Trace>> TRACES_FIELD = SdkField
            .<List<Trace>> builder(MarshallingType.LIST)
            .memberName("Traces")
            .getter(getter(BatchGetTracesResponse::traces))
            .setter(setter(Builder::traces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trace> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> UNPROCESSED_TRACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UnprocessedTraceIds")
            .getter(getter(BatchGetTracesResponse::unprocessedTraceIds))
            .setter(setter(Builder::unprocessedTraceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedTraceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(BatchGetTracesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACES_FIELD,
            UNPROCESSED_TRACE_IDS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Trace> traces;

    private final List<String> unprocessedTraceIds;

    private final String nextToken;

    private BatchGetTracesResponse(BuilderImpl builder) {
        super(builder);
        this.traces = builder.traces;
        this.unprocessedTraceIds = builder.unprocessedTraceIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Traces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTraces() {
        return traces != null && !(traces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Full traces for the specified requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTraces} method.
     * </p>
     * 
     * @return Full traces for the specified requests.
     */
    public final List<Trace> traces() {
        return traces;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedTraceIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedTraceIds() {
        return unprocessedTraceIds != null && !(unprocessedTraceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Trace IDs of requests that haven't been processed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedTraceIds} method.
     * </p>
     * 
     * @return Trace IDs of requests that haven't been processed.
     */
    public final List<String> unprocessedTraceIds() {
        return unprocessedTraceIds;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTraces() ? traces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedTraceIds() ? unprocessedTraceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTracesResponse)) {
            return false;
        }
        BatchGetTracesResponse other = (BatchGetTracesResponse) obj;
        return hasTraces() == other.hasTraces() && Objects.equals(traces(), other.traces())
                && hasUnprocessedTraceIds() == other.hasUnprocessedTraceIds()
                && Objects.equals(unprocessedTraceIds(), other.unprocessedTraceIds())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetTracesResponse").add("Traces", hasTraces() ? traces() : null)
                .add("UnprocessedTraceIds", hasUnprocessedTraceIds() ? unprocessedTraceIds() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Traces":
            return Optional.ofNullable(clazz.cast(traces()));
        case "UnprocessedTraceIds":
            return Optional.ofNullable(clazz.cast(unprocessedTraceIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTracesResponse, T> g) {
        return obj -> g.apply((BatchGetTracesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetTracesResponse> {
        /**
         * <p>
         * Full traces for the specified requests.
         * </p>
         * 
         * @param traces
         *        Full traces for the specified requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traces(Collection<Trace> traces);

        /**
         * <p>
         * Full traces for the specified requests.
         * </p>
         * 
         * @param traces
         *        Full traces for the specified requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traces(Trace... traces);

        /**
         * <p>
         * Full traces for the specified requests.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.Trace.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.xray.model.Trace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.xray.model.Trace.Builder#build()}
         * is called immediately and its result is passed to {@link #traces(List<Trace>)}.
         * 
         * @param traces
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.xray.model.Trace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traces(java.util.Collection<Trace>)
         */
        Builder traces(Consumer<Trace.Builder>... traces);

        /**
         * <p>
         * Trace IDs of requests that haven't been processed.
         * </p>
         * 
         * @param unprocessedTraceIds
         *        Trace IDs of requests that haven't been processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedTraceIds(Collection<String> unprocessedTraceIds);

        /**
         * <p>
         * Trace IDs of requests that haven't been processed.
         * </p>
         * 
         * @param unprocessedTraceIds
         *        Trace IDs of requests that haven't been processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedTraceIds(String... unprocessedTraceIds);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private List<Trace> traces = DefaultSdkAutoConstructList.getInstance();

        private List<String> unprocessedTraceIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTracesResponse model) {
            super(model);
            traces(model.traces);
            unprocessedTraceIds(model.unprocessedTraceIds);
            nextToken(model.nextToken);
        }

        public final List<Trace.Builder> getTraces() {
            List<Trace.Builder> result = TraceListCopier.copyToBuilder(this.traces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraces(Collection<Trace.BuilderImpl> traces) {
            this.traces = TraceListCopier.copyFromBuilder(traces);
        }

        @Override
        public final Builder traces(Collection<Trace> traces) {
            this.traces = TraceListCopier.copy(traces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traces(Trace... traces) {
            traces(Arrays.asList(traces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traces(Consumer<Trace.Builder>... traces) {
            traces(Stream.of(traces).map(c -> Trace.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getUnprocessedTraceIds() {
            if (unprocessedTraceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return unprocessedTraceIds;
        }

        public final void setUnprocessedTraceIds(Collection<String> unprocessedTraceIds) {
            this.unprocessedTraceIds = UnprocessedTraceIdListCopier.copy(unprocessedTraceIds);
        }

        @Override
        public final Builder unprocessedTraceIds(Collection<String> unprocessedTraceIds) {
            this.unprocessedTraceIds = UnprocessedTraceIdListCopier.copy(unprocessedTraceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedTraceIds(String... unprocessedTraceIds) {
            unprocessedTraceIds(Arrays.asList(unprocessedTraceIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public BatchGetTracesResponse build() {
            return new BatchGetTracesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
