/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTraceSummariesResponse extends XRayResponse implements
        ToCopyableBuilder<GetTraceSummariesResponse.Builder, GetTraceSummariesResponse> {
    private static final SdkField<List<TraceSummary>> TRACE_SUMMARIES_FIELD = SdkField
            .<List<TraceSummary>> builder(MarshallingType.LIST)
            .memberName("TraceSummaries")
            .getter(getter(GetTraceSummariesResponse::traceSummaries))
            .setter(setter(Builder::traceSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TraceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TraceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> APPROXIMATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ApproximateTime").getter(getter(GetTraceSummariesResponse::approximateTime))
            .setter(setter(Builder::approximateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTime").build()).build();

    private static final SdkField<Long> TRACES_PROCESSED_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TracesProcessedCount").getter(getter(GetTraceSummariesResponse::tracesProcessedCount))
            .setter(setter(Builder::tracesProcessedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracesProcessedCount").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetTraceSummariesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_SUMMARIES_FIELD,
            APPROXIMATE_TIME_FIELD, TRACES_PROCESSED_COUNT_FIELD, NEXT_TOKEN_FIELD));

    private final List<TraceSummary> traceSummaries;

    private final Instant approximateTime;

    private final Long tracesProcessedCount;

    private final String nextToken;

    private GetTraceSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.traceSummaries = builder.traceSummaries;
        this.approximateTime = builder.approximateTime;
        this.tracesProcessedCount = builder.tracesProcessedCount;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TraceSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTraceSummaries() {
        return traceSummaries != null && !(traceSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Trace IDs and annotations for traces that were found in the specified time frame.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTraceSummaries} method.
     * </p>
     * 
     * @return Trace IDs and annotations for traces that were found in the specified time frame.
     */
    public final List<TraceSummary> traceSummaries() {
        return traceSummaries;
    }

    /**
     * <p>
     * The start time of this page of results.
     * </p>
     * 
     * @return The start time of this page of results.
     */
    public final Instant approximateTime() {
        return approximateTime;
    }

    /**
     * <p>
     * The total number of traces processed, including traces that did not match the specified filter expression.
     * </p>
     * 
     * @return The total number of traces processed, including traces that did not match the specified filter
     *         expression.
     */
    public final Long tracesProcessedCount() {
        return tracesProcessedCount;
    }

    /**
     * <p>
     * If the requested time frame contained more than one page of results, you can use this token to retrieve the next
     * page. The first page contains the most recent results, closest to the end of the time frame.
     * </p>
     * 
     * @return If the requested time frame contained more than one page of results, you can use this token to retrieve
     *         the next page. The first page contains the most recent results, closest to the end of the time frame.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTraceSummaries() ? traceSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(approximateTime());
        hashCode = 31 * hashCode + Objects.hashCode(tracesProcessedCount());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceSummariesResponse)) {
            return false;
        }
        GetTraceSummariesResponse other = (GetTraceSummariesResponse) obj;
        return hasTraceSummaries() == other.hasTraceSummaries() && Objects.equals(traceSummaries(), other.traceSummaries())
                && Objects.equals(approximateTime(), other.approximateTime())
                && Objects.equals(tracesProcessedCount(), other.tracesProcessedCount())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTraceSummariesResponse").add("TraceSummaries", hasTraceSummaries() ? traceSummaries() : null)
                .add("ApproximateTime", approximateTime()).add("TracesProcessedCount", tracesProcessedCount())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TraceSummaries":
            return Optional.ofNullable(clazz.cast(traceSummaries()));
        case "ApproximateTime":
            return Optional.ofNullable(clazz.cast(approximateTime()));
        case "TracesProcessedCount":
            return Optional.ofNullable(clazz.cast(tracesProcessedCount()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTraceSummariesResponse, T> g) {
        return obj -> g.apply((GetTraceSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTraceSummariesResponse> {
        /**
         * <p>
         * Trace IDs and annotations for traces that were found in the specified time frame.
         * </p>
         * 
         * @param traceSummaries
         *        Trace IDs and annotations for traces that were found in the specified time frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceSummaries(Collection<TraceSummary> traceSummaries);

        /**
         * <p>
         * Trace IDs and annotations for traces that were found in the specified time frame.
         * </p>
         * 
         * @param traceSummaries
         *        Trace IDs and annotations for traces that were found in the specified time frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceSummaries(TraceSummary... traceSummaries);

        /**
         * <p>
         * Trace IDs and annotations for traces that were found in the specified time frame.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.TraceSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.xray.model.TraceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.TraceSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #traceSummaries(List<TraceSummary>)}.
         * 
         * @param traceSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.TraceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traceSummaries(java.util.Collection<TraceSummary>)
         */
        Builder traceSummaries(Consumer<TraceSummary.Builder>... traceSummaries);

        /**
         * <p>
         * The start time of this page of results.
         * </p>
         * 
         * @param approximateTime
         *        The start time of this page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateTime(Instant approximateTime);

        /**
         * <p>
         * The total number of traces processed, including traces that did not match the specified filter expression.
         * </p>
         * 
         * @param tracesProcessedCount
         *        The total number of traces processed, including traces that did not match the specified filter
         *        expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracesProcessedCount(Long tracesProcessedCount);

        /**
         * <p>
         * If the requested time frame contained more than one page of results, you can use this token to retrieve the
         * next page. The first page contains the most recent results, closest to the end of the time frame.
         * </p>
         * 
         * @param nextToken
         *        If the requested time frame contained more than one page of results, you can use this token to
         *        retrieve the next page. The first page contains the most recent results, closest to the end of the
         *        time frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private List<TraceSummary> traceSummaries = DefaultSdkAutoConstructList.getInstance();

        private Instant approximateTime;

        private Long tracesProcessedCount;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceSummariesResponse model) {
            super(model);
            traceSummaries(model.traceSummaries);
            approximateTime(model.approximateTime);
            tracesProcessedCount(model.tracesProcessedCount);
            nextToken(model.nextToken);
        }

        public final List<TraceSummary.Builder> getTraceSummaries() {
            List<TraceSummary.Builder> result = TraceSummaryListCopier.copyToBuilder(this.traceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraceSummaries(Collection<TraceSummary.BuilderImpl> traceSummaries) {
            this.traceSummaries = TraceSummaryListCopier.copyFromBuilder(traceSummaries);
        }

        @Override
        public final Builder traceSummaries(Collection<TraceSummary> traceSummaries) {
            this.traceSummaries = TraceSummaryListCopier.copy(traceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceSummaries(TraceSummary... traceSummaries) {
            traceSummaries(Arrays.asList(traceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceSummaries(Consumer<TraceSummary.Builder>... traceSummaries) {
            traceSummaries(Stream.of(traceSummaries).map(c -> TraceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getApproximateTime() {
            return approximateTime;
        }

        public final void setApproximateTime(Instant approximateTime) {
            this.approximateTime = approximateTime;
        }

        @Override
        public final Builder approximateTime(Instant approximateTime) {
            this.approximateTime = approximateTime;
            return this;
        }

        public final Long getTracesProcessedCount() {
            return tracesProcessedCount;
        }

        public final void setTracesProcessedCount(Long tracesProcessedCount) {
            this.tracesProcessedCount = tracesProcessedCount;
        }

        @Override
        public final Builder tracesProcessedCount(Long tracesProcessedCount) {
            this.tracesProcessedCount = tracesProcessedCount;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTraceSummariesResponse build() {
            return new GetTraceSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
