/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a user recorded in segment documents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TraceUser implements SdkPojo, Serializable, ToCopyableBuilder<TraceUser.Builder, TraceUser> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(TraceUser::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<List<ServiceId>> SERVICE_IDS_FIELD = SdkField
            .<List<ServiceId>> builder(MarshallingType.LIST)
            .memberName("ServiceIds")
            .getter(getter(TraceUser::serviceIds))
            .setter(setter(Builder::serviceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceId> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            SERVICE_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final List<ServiceId> serviceIds;

    private TraceUser(BuilderImpl builder) {
        this.userName = builder.userName;
        this.serviceIds = builder.serviceIds;
    }

    /**
     * <p>
     * The user's name.
     * </p>
     * 
     * @return The user's name.
     */
    public final String userName() {
        return userName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServiceIds() {
        return serviceIds != null && !(serviceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Services that the user's request hit.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceIds} method.
     * </p>
     * 
     * @return Services that the user's request hit.
     */
    public final List<ServiceId> serviceIds() {
        return serviceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceIds() ? serviceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceUser)) {
            return false;
        }
        TraceUser other = (TraceUser) obj;
        return Objects.equals(userName(), other.userName()) && hasServiceIds() == other.hasServiceIds()
                && Objects.equals(serviceIds(), other.serviceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TraceUser").add("UserName", userName()).add("ServiceIds", hasServiceIds() ? serviceIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "ServiceIds":
            return Optional.ofNullable(clazz.cast(serviceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TraceUser, T> g) {
        return obj -> g.apply((TraceUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TraceUser> {
        /**
         * <p>
         * The user's name.
         * </p>
         * 
         * @param userName
         *        The user's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Services that the user's request hit.
         * </p>
         * 
         * @param serviceIds
         *        Services that the user's request hit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIds(Collection<ServiceId> serviceIds);

        /**
         * <p>
         * Services that the user's request hit.
         * </p>
         * 
         * @param serviceIds
         *        Services that the user's request hit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIds(ServiceId... serviceIds);

        /**
         * <p>
         * Services that the user's request hit.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.ServiceId.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.xray.model.ServiceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.ServiceId.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceIds(List<ServiceId>)}.
         * 
         * @param serviceIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.ServiceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceIds(java.util.Collection<ServiceId>)
         */
        Builder serviceIds(Consumer<ServiceId.Builder>... serviceIds);
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private List<ServiceId> serviceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TraceUser model) {
            userName(model.userName);
            serviceIds(model.serviceIds);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final List<ServiceId.Builder> getServiceIds() {
            List<ServiceId.Builder> result = ServiceIdsCopier.copyToBuilder(this.serviceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceIds(Collection<ServiceId.BuilderImpl> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copyFromBuilder(serviceIds);
        }

        @Override
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(ServiceId... serviceIds) {
            serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(Consumer<ServiceId.Builder>... serviceIds) {
            serviceIds(Stream.of(serviceIds).map(c -> ServiceId.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TraceUser build() {
            return new TraceUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
