/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.xray.model.XRayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServiceGraphRequest
extends XRayRequest
implements ToCopyableBuilder<Builder, GetServiceGraphRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetServiceGraphRequest.getter(GetServiceGraphRequest::startTime)).setter(GetServiceGraphRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetServiceGraphRequest.getter(GetServiceGraphRequest::endTime)).setter(GetServiceGraphRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(GetServiceGraphRequest.getter(GetServiceGraphRequest::groupName)).setter(GetServiceGraphRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupARN").getter(GetServiceGraphRequest.getter(GetServiceGraphRequest::groupARN)).setter(GetServiceGraphRequest.setter(Builder::groupARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupARN").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetServiceGraphRequest.getter(GetServiceGraphRequest::nextToken)).setter(GetServiceGraphRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, GROUP_NAME_FIELD, GROUP_ARN_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("GroupName", GROUP_NAME_FIELD);
            this.put("GroupARN", GROUP_ARN_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final Instant startTime;
    private final Instant endTime;
    private final String groupName;
    private final String groupARN;
    private final String nextToken;

    private GetServiceGraphRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.groupName = builder.groupName;
        this.groupARN = builder.groupARN;
        this.nextToken = builder.nextToken;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String groupARN() {
        return this.groupARN;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceGraphRequest)) {
            return false;
        }
        GetServiceGraphRequest other = (GetServiceGraphRequest)((Object)obj);
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.groupARN(), other.groupARN()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetServiceGraphRequest").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("GroupName", (Object)this.groupName()).add("GroupARN", (Object)this.groupARN()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "GroupARN": {
                return Optional.ofNullable(clazz.cast(this.groupARN()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceGraphRequest, T> g) {
        return obj -> g.apply((GetServiceGraphRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayRequest.BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private String groupName;
        private String groupARN;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceGraphRequest model) {
            super(model);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.groupName(model.groupName);
            this.groupARN(model.groupARN);
            this.nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroupARN() {
            return this.groupARN;
        }

        public final void setGroupARN(String groupARN) {
            this.groupARN = groupARN;
        }

        @Override
        public final Builder groupARN(String groupARN) {
            this.groupARN = groupARN;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetServiceGraphRequest build() {
            return new GetServiceGraphRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends XRayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServiceGraphRequest> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder groupName(String var1);

        public Builder groupARN(String var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

