/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.InsightSummary;
import software.amazon.awssdk.services.xray.model.InsightSummaryListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInsightSummariesResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetInsightSummariesResponse> {
    private static final SdkField<List<InsightSummary>> INSIGHT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsightSummaries").getter(GetInsightSummariesResponse.getter(GetInsightSummariesResponse::insightSummaries)).setter(GetInsightSummariesResponse.setter(Builder::insightSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetInsightSummariesResponse.getter(GetInsightSummariesResponse::nextToken)).setter(GetInsightSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InsightSummaries", INSIGHT_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<InsightSummary> insightSummaries;
    private final String nextToken;

    private GetInsightSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.insightSummaries = builder.insightSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInsightSummaries() {
        return this.insightSummaries != null && !(this.insightSummaries instanceof SdkAutoConstructList);
    }

    public final List<InsightSummary> insightSummaries() {
        return this.insightSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsightSummaries() ? this.insightSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightSummariesResponse)) {
            return false;
        }
        GetInsightSummariesResponse other = (GetInsightSummariesResponse)((Object)obj);
        return this.hasInsightSummaries() == other.hasInsightSummaries() && Objects.equals(this.insightSummaries(), other.insightSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetInsightSummariesResponse").add("InsightSummaries", this.hasInsightSummaries() ? this.insightSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsightSummaries": {
                return Optional.ofNullable(clazz.cast(this.insightSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightSummariesResponse, T> g) {
        return obj -> g.apply((GetInsightSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<InsightSummary> insightSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightSummariesResponse model) {
            super(model);
            this.insightSummaries(model.insightSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<InsightSummary.Builder> getInsightSummaries() {
            List<InsightSummary.Builder> result = InsightSummaryListCopier.copyToBuilder(this.insightSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsightSummaries(Collection<InsightSummary.BuilderImpl> insightSummaries) {
            this.insightSummaries = InsightSummaryListCopier.copyFromBuilder(insightSummaries);
        }

        @Override
        public final Builder insightSummaries(Collection<InsightSummary> insightSummaries) {
            this.insightSummaries = InsightSummaryListCopier.copy(insightSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSummaries(InsightSummary ... insightSummaries) {
            this.insightSummaries(Arrays.asList(insightSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSummaries(Consumer<InsightSummary.Builder> ... insightSummaries) {
            this.insightSummaries(Stream.of(insightSummaries).map(c -> (InsightSummary)((InsightSummary.Builder)InsightSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetInsightSummariesResponse build() {
            return new GetInsightSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInsightSummariesResponse> {
        public Builder insightSummaries(Collection<InsightSummary> var1);

        public Builder insightSummaries(InsightSummary ... var1);

        public Builder insightSummaries(Consumer<InsightSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

