/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.RetrievalStatus;
import software.amazon.awssdk.services.xray.model.RetrievedTrace;
import software.amazon.awssdk.services.xray.model.TraceFormatType;
import software.amazon.awssdk.services.xray.model.TraceSpanListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRetrievedTracesResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, ListRetrievedTracesResponse> {
    private static final SdkField<String> RETRIEVAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrievalStatus").getter(ListRetrievedTracesResponse.getter(ListRetrievedTracesResponse::retrievalStatusAsString)).setter(ListRetrievedTracesResponse.setter(Builder::retrievalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalStatus").build()}).build();
    private static final SdkField<String> TRACE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TraceFormat").getter(ListRetrievedTracesResponse.getter(ListRetrievedTracesResponse::traceFormatAsString)).setter(ListRetrievedTracesResponse.setter(Builder::traceFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceFormat").build()}).build();
    private static final SdkField<List<RetrievedTrace>> TRACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Traces").getter(ListRetrievedTracesResponse.getter(ListRetrievedTracesResponse::traces)).setter(ListRetrievedTracesResponse.setter(Builder::traces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RetrievedTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRetrievedTracesResponse.getter(ListRetrievedTracesResponse::nextToken)).setter(ListRetrievedTracesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVAL_STATUS_FIELD, TRACE_FORMAT_FIELD, TRACES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RetrievalStatus", RETRIEVAL_STATUS_FIELD);
            this.put("TraceFormat", TRACE_FORMAT_FIELD);
            this.put("Traces", TRACES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String retrievalStatus;
    private final String traceFormat;
    private final List<RetrievedTrace> traces;
    private final String nextToken;

    private ListRetrievedTracesResponse(BuilderImpl builder) {
        super(builder);
        this.retrievalStatus = builder.retrievalStatus;
        this.traceFormat = builder.traceFormat;
        this.traces = builder.traces;
        this.nextToken = builder.nextToken;
    }

    public final RetrievalStatus retrievalStatus() {
        return RetrievalStatus.fromValue(this.retrievalStatus);
    }

    public final String retrievalStatusAsString() {
        return this.retrievalStatus;
    }

    public final TraceFormatType traceFormat() {
        return TraceFormatType.fromValue(this.traceFormat);
    }

    public final String traceFormatAsString() {
        return this.traceFormat;
    }

    public final boolean hasTraces() {
        return this.traces != null && !(this.traces instanceof SdkAutoConstructList);
    }

    public final List<RetrievedTrace> traces() {
        return this.traces;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTraces() ? this.traces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetrievedTracesResponse)) {
            return false;
        }
        ListRetrievedTracesResponse other = (ListRetrievedTracesResponse)((Object)obj);
        return Objects.equals(this.retrievalStatusAsString(), other.retrievalStatusAsString()) && Objects.equals(this.traceFormatAsString(), other.traceFormatAsString()) && this.hasTraces() == other.hasTraces() && Objects.equals(this.traces(), other.traces()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRetrievedTracesResponse").add("RetrievalStatus", (Object)this.retrievalStatusAsString()).add("TraceFormat", (Object)this.traceFormatAsString()).add("Traces", this.hasTraces() ? this.traces() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetrievalStatus": {
                return Optional.ofNullable(clazz.cast(this.retrievalStatusAsString()));
            }
            case "TraceFormat": {
                return Optional.ofNullable(clazz.cast(this.traceFormatAsString()));
            }
            case "Traces": {
                return Optional.ofNullable(clazz.cast(this.traces()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRetrievedTracesResponse, T> g) {
        return obj -> g.apply((ListRetrievedTracesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private String retrievalStatus;
        private String traceFormat;
        private List<RetrievedTrace> traces = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetrievedTracesResponse model) {
            super(model);
            this.retrievalStatus(model.retrievalStatus);
            this.traceFormat(model.traceFormat);
            this.traces(model.traces);
            this.nextToken(model.nextToken);
        }

        public final String getRetrievalStatus() {
            return this.retrievalStatus;
        }

        public final void setRetrievalStatus(String retrievalStatus) {
            this.retrievalStatus = retrievalStatus;
        }

        @Override
        public final Builder retrievalStatus(String retrievalStatus) {
            this.retrievalStatus = retrievalStatus;
            return this;
        }

        @Override
        public final Builder retrievalStatus(RetrievalStatus retrievalStatus) {
            this.retrievalStatus(retrievalStatus == null ? null : retrievalStatus.toString());
            return this;
        }

        public final String getTraceFormat() {
            return this.traceFormat;
        }

        public final void setTraceFormat(String traceFormat) {
            this.traceFormat = traceFormat;
        }

        @Override
        public final Builder traceFormat(String traceFormat) {
            this.traceFormat = traceFormat;
            return this;
        }

        @Override
        public final Builder traceFormat(TraceFormatType traceFormat) {
            this.traceFormat(traceFormat == null ? null : traceFormat.toString());
            return this;
        }

        public final List<RetrievedTrace.Builder> getTraces() {
            List<RetrievedTrace.Builder> result = TraceSpanListCopier.copyToBuilder(this.traces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraces(Collection<RetrievedTrace.BuilderImpl> traces) {
            this.traces = TraceSpanListCopier.copyFromBuilder(traces);
        }

        @Override
        public final Builder traces(Collection<RetrievedTrace> traces) {
            this.traces = TraceSpanListCopier.copy(traces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traces(RetrievedTrace ... traces) {
            this.traces(Arrays.asList(traces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traces(Consumer<RetrievedTrace.Builder> ... traces) {
            this.traces(Stream.of(traces).map(c -> (RetrievedTrace)((RetrievedTrace.Builder)RetrievedTrace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRetrievedTracesResponse build() {
            return new ListRetrievedTracesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRetrievedTracesResponse> {
        public Builder retrievalStatus(String var1);

        public Builder retrievalStatus(RetrievalStatus var1);

        public Builder traceFormat(String var1);

        public Builder traceFormat(TraceFormatType var1);

        public Builder traces(Collection<RetrievedTrace> var1);

        public Builder traces(RetrievedTrace ... var1);

        public Builder traces(Consumer<RetrievedTrace.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

