/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about requests that failed with a 4xx Client Error status code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorStatistics implements SdkPojo, Serializable, ToCopyableBuilder<ErrorStatistics.Builder, ErrorStatistics> {
    private static final SdkField<Long> THROTTLE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ThrottleCount").getter(getter(ErrorStatistics::throttleCount)).setter(setter(Builder::throttleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThrottleCount").build()).build();

    private static final SdkField<Long> OTHER_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OtherCount").getter(getter(ErrorStatistics::otherCount)).setter(setter(Builder::otherCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherCount").build()).build();

    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalCount").getter(getter(ErrorStatistics::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THROTTLE_COUNT_FIELD,
            OTHER_COUNT_FIELD, TOTAL_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long throttleCount;

    private final Long otherCount;

    private final Long totalCount;

    private ErrorStatistics(BuilderImpl builder) {
        this.throttleCount = builder.throttleCount;
        this.otherCount = builder.otherCount;
        this.totalCount = builder.totalCount;
    }

    /**
     * <p>
     * The number of requests that failed with a 429 throttling status code.
     * </p>
     * 
     * @return The number of requests that failed with a 429 throttling status code.
     */
    public final Long throttleCount() {
        return throttleCount;
    }

    /**
     * <p>
     * The number of requests that failed with untracked 4xx Client Error status codes.
     * </p>
     * 
     * @return The number of requests that failed with untracked 4xx Client Error status codes.
     */
    public final Long otherCount() {
        return otherCount;
    }

    /**
     * <p>
     * The total number of requests that failed with a 4xx Client Error status code.
     * </p>
     * 
     * @return The total number of requests that failed with a 4xx Client Error status code.
     */
    public final Long totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(throttleCount());
        hashCode = 31 * hashCode + Objects.hashCode(otherCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorStatistics)) {
            return false;
        }
        ErrorStatistics other = (ErrorStatistics) obj;
        return Objects.equals(throttleCount(), other.throttleCount()) && Objects.equals(otherCount(), other.otherCount())
                && Objects.equals(totalCount(), other.totalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorStatistics").add("ThrottleCount", throttleCount()).add("OtherCount", otherCount())
                .add("TotalCount", totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThrottleCount":
            return Optional.ofNullable(clazz.cast(throttleCount()));
        case "OtherCount":
            return Optional.ofNullable(clazz.cast(otherCount()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ThrottleCount", THROTTLE_COUNT_FIELD);
        map.put("OtherCount", OTHER_COUNT_FIELD);
        map.put("TotalCount", TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ErrorStatistics, T> g) {
        return obj -> g.apply((ErrorStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorStatistics> {
        /**
         * <p>
         * The number of requests that failed with a 429 throttling status code.
         * </p>
         * 
         * @param throttleCount
         *        The number of requests that failed with a 429 throttling status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttleCount(Long throttleCount);

        /**
         * <p>
         * The number of requests that failed with untracked 4xx Client Error status codes.
         * </p>
         * 
         * @param otherCount
         *        The number of requests that failed with untracked 4xx Client Error status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherCount(Long otherCount);

        /**
         * <p>
         * The total number of requests that failed with a 4xx Client Error status code.
         * </p>
         * 
         * @param totalCount
         *        The total number of requests that failed with a 4xx Client Error status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Long totalCount);
    }

    static final class BuilderImpl implements Builder {
        private Long throttleCount;

        private Long otherCount;

        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorStatistics model) {
            throttleCount(model.throttleCount);
            otherCount(model.otherCount);
            totalCount(model.totalCount);
        }

        public final Long getThrottleCount() {
            return throttleCount;
        }

        public final void setThrottleCount(Long throttleCount) {
            this.throttleCount = throttleCount;
        }

        @Override
        public final Builder throttleCount(Long throttleCount) {
            this.throttleCount = throttleCount;
            return this;
        }

        public final Long getOtherCount() {
            return otherCount;
        }

        public final void setOtherCount(Long otherCount) {
            this.otherCount = otherCount;
        }

        @Override
        public final Builder otherCount(Long otherCount) {
            this.otherCount = otherCount;
            return this;
        }

        public final Long getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public ErrorStatistics build() {
            return new ErrorStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
