/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The root cause information for a trace summary fault.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FaultRootCause implements SdkPojo, Serializable, ToCopyableBuilder<FaultRootCause.Builder, FaultRootCause> {
    private static final SdkField<List<FaultRootCauseService>> SERVICES_FIELD = SdkField
            .<List<FaultRootCauseService>> builder(MarshallingType.LIST)
            .memberName("Services")
            .getter(getter(FaultRootCause::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FaultRootCauseService> builder(MarshallingType.SDK_POJO)
                                            .constructor(FaultRootCauseService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> CLIENT_IMPACTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ClientImpacting").getter(getter(FaultRootCause::clientImpacting))
            .setter(setter(Builder::clientImpacting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientImpacting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD,
            CLIENT_IMPACTING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FaultRootCauseService> services;

    private final Boolean clientImpacting;

    private FaultRootCause(BuilderImpl builder) {
        this.services = builder.services;
        this.clientImpacting = builder.clientImpacting;
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of corresponding services. A service identifies a segment and it contains a name, account ID, type, and
     * inferred flag.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return A list of corresponding services. A service identifies a segment and it contains a name, account ID,
     *         type, and inferred flag.
     */
    public final List<FaultRootCauseService> services() {
        return services;
    }

    /**
     * <p>
     * A flag that denotes that the root cause impacts the trace client.
     * </p>
     * 
     * @return A flag that denotes that the root cause impacts the trace client.
     */
    public final Boolean clientImpacting() {
        return clientImpacting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientImpacting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaultRootCause)) {
            return false;
        }
        FaultRootCause other = (FaultRootCause) obj;
        return hasServices() == other.hasServices() && Objects.equals(services(), other.services())
                && Objects.equals(clientImpacting(), other.clientImpacting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FaultRootCause").add("Services", hasServices() ? services() : null)
                .add("ClientImpacting", clientImpacting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Services":
            return Optional.ofNullable(clazz.cast(services()));
        case "ClientImpacting":
            return Optional.ofNullable(clazz.cast(clientImpacting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Services", SERVICES_FIELD);
        map.put("ClientImpacting", CLIENT_IMPACTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FaultRootCause, T> g) {
        return obj -> g.apply((FaultRootCause) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FaultRootCause> {
        /**
         * <p>
         * A list of corresponding services. A service identifies a segment and it contains a name, account ID, type,
         * and inferred flag.
         * </p>
         * 
         * @param services
         *        A list of corresponding services. A service identifies a segment and it contains a name, account ID,
         *        type, and inferred flag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<FaultRootCauseService> services);

        /**
         * <p>
         * A list of corresponding services. A service identifies a segment and it contains a name, account ID, type,
         * and inferred flag.
         * </p>
         * 
         * @param services
         *        A list of corresponding services. A service identifies a segment and it contains a name, account ID,
         *        type, and inferred flag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(FaultRootCauseService... services);

        /**
         * <p>
         * A list of corresponding services. A service identifies a segment and it contains a name, account ID, type,
         * and inferred flag.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.FaultRootCauseService.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.xray.model.FaultRootCauseService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.FaultRootCauseService.Builder#build()} is called
         * immediately and its result is passed to {@link #services(List<FaultRootCauseService>)}.
         * 
         * @param services
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.FaultRootCauseService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(java.util.Collection<FaultRootCauseService>)
         */
        Builder services(Consumer<FaultRootCauseService.Builder>... services);

        /**
         * <p>
         * A flag that denotes that the root cause impacts the trace client.
         * </p>
         * 
         * @param clientImpacting
         *        A flag that denotes that the root cause impacts the trace client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientImpacting(Boolean clientImpacting);
    }

    static final class BuilderImpl implements Builder {
        private List<FaultRootCauseService> services = DefaultSdkAutoConstructList.getInstance();

        private Boolean clientImpacting;

        private BuilderImpl() {
        }

        private BuilderImpl(FaultRootCause model) {
            services(model.services);
            clientImpacting(model.clientImpacting);
        }

        public final List<FaultRootCauseService.Builder> getServices() {
            List<FaultRootCauseService.Builder> result = FaultRootCauseServicesCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<FaultRootCauseService.BuilderImpl> services) {
            this.services = FaultRootCauseServicesCopier.copyFromBuilder(services);
        }

        @Override
        public final Builder services(Collection<FaultRootCauseService> services) {
            this.services = FaultRootCauseServicesCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(FaultRootCauseService... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<FaultRootCauseService.Builder>... services) {
            services(Stream.of(services).map(c -> FaultRootCauseService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getClientImpacting() {
            return clientImpacting;
        }

        public final void setClientImpacting(Boolean clientImpacting) {
            this.clientImpacting = clientImpacting;
        }

        @Override
        public final Builder clientImpacting(Boolean clientImpacting) {
            this.clientImpacting = clientImpacting;
            return this;
        }

        @Override
        public FaultRootCause build() {
            return new FaultRootCause(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
