/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The relation between two services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GraphLink implements SdkPojo, Serializable, ToCopyableBuilder<GraphLink.Builder, GraphLink> {
    private static final SdkField<String> REFERENCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReferenceType").getter(getter(GraphLink::referenceType)).setter(setter(Builder::referenceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceType").build()).build();

    private static final SdkField<String> SOURCE_TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceTraceId").getter(getter(GraphLink::sourceTraceId)).setter(setter(Builder::sourceTraceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTraceId").build()).build();

    private static final SdkField<List<String>> DESTINATION_TRACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DestinationTraceIds")
            .getter(getter(GraphLink::destinationTraceIds))
            .setter(setter(Builder::destinationTraceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTraceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_TYPE_FIELD,
            SOURCE_TRACE_ID_FIELD, DESTINATION_TRACE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String referenceType;

    private final String sourceTraceId;

    private final List<String> destinationTraceIds;

    private GraphLink(BuilderImpl builder) {
        this.referenceType = builder.referenceType;
        this.sourceTraceId = builder.sourceTraceId;
        this.destinationTraceIds = builder.destinationTraceIds;
    }

    /**
     * <p>
     * Relationship of a trace to the corresponding service.
     * </p>
     * 
     * @return Relationship of a trace to the corresponding service.
     */
    public final String referenceType() {
        return referenceType;
    }

    /**
     * <p>
     * Source trace of a link relationship.
     * </p>
     * 
     * @return Source trace of a link relationship.
     */
    public final String sourceTraceId() {
        return sourceTraceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationTraceIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinationTraceIds() {
        return destinationTraceIds != null && !(destinationTraceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Destination traces of a link relationship.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationTraceIds} method.
     * </p>
     * 
     * @return Destination traces of a link relationship.
     */
    public final List<String> destinationTraceIds() {
        return destinationTraceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(referenceType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTraceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationTraceIds() ? destinationTraceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphLink)) {
            return false;
        }
        GraphLink other = (GraphLink) obj;
        return Objects.equals(referenceType(), other.referenceType()) && Objects.equals(sourceTraceId(), other.sourceTraceId())
                && hasDestinationTraceIds() == other.hasDestinationTraceIds()
                && Objects.equals(destinationTraceIds(), other.destinationTraceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GraphLink").add("ReferenceType", referenceType()).add("SourceTraceId", sourceTraceId())
                .add("DestinationTraceIds", hasDestinationTraceIds() ? destinationTraceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReferenceType":
            return Optional.ofNullable(clazz.cast(referenceType()));
        case "SourceTraceId":
            return Optional.ofNullable(clazz.cast(sourceTraceId()));
        case "DestinationTraceIds":
            return Optional.ofNullable(clazz.cast(destinationTraceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReferenceType", REFERENCE_TYPE_FIELD);
        map.put("SourceTraceId", SOURCE_TRACE_ID_FIELD);
        map.put("DestinationTraceIds", DESTINATION_TRACE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GraphLink, T> g) {
        return obj -> g.apply((GraphLink) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GraphLink> {
        /**
         * <p>
         * Relationship of a trace to the corresponding service.
         * </p>
         * 
         * @param referenceType
         *        Relationship of a trace to the corresponding service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceType(String referenceType);

        /**
         * <p>
         * Source trace of a link relationship.
         * </p>
         * 
         * @param sourceTraceId
         *        Source trace of a link relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTraceId(String sourceTraceId);

        /**
         * <p>
         * Destination traces of a link relationship.
         * </p>
         * 
         * @param destinationTraceIds
         *        Destination traces of a link relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTraceIds(Collection<String> destinationTraceIds);

        /**
         * <p>
         * Destination traces of a link relationship.
         * </p>
         * 
         * @param destinationTraceIds
         *        Destination traces of a link relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTraceIds(String... destinationTraceIds);
    }

    static final class BuilderImpl implements Builder {
        private String referenceType;

        private String sourceTraceId;

        private List<String> destinationTraceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GraphLink model) {
            referenceType(model.referenceType);
            sourceTraceId(model.sourceTraceId);
            destinationTraceIds(model.destinationTraceIds);
        }

        public final String getReferenceType() {
            return referenceType;
        }

        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        public final String getSourceTraceId() {
            return sourceTraceId;
        }

        public final void setSourceTraceId(String sourceTraceId) {
            this.sourceTraceId = sourceTraceId;
        }

        @Override
        public final Builder sourceTraceId(String sourceTraceId) {
            this.sourceTraceId = sourceTraceId;
            return this;
        }

        public final Collection<String> getDestinationTraceIds() {
            if (destinationTraceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationTraceIds;
        }

        public final void setDestinationTraceIds(Collection<String> destinationTraceIds) {
            this.destinationTraceIds = TraceIdListCopier.copy(destinationTraceIds);
        }

        @Override
        public final Builder destinationTraceIds(Collection<String> destinationTraceIds) {
            this.destinationTraceIds = TraceIdListCopier.copy(destinationTraceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationTraceIds(String... destinationTraceIds) {
            destinationTraceIds(Arrays.asList(destinationTraceIds));
            return this;
        }

        @Override
        public GraphLink build() {
            return new GraphLink(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
