/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for a group without metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupSummary implements SdkPojo, Serializable, ToCopyableBuilder<GroupSummary.Builder, GroupSummary> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(GroupSummary::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupARN").getter(getter(GroupSummary::groupARN)).setter(setter(Builder::groupARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupARN").build()).build();

    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterExpression").getter(getter(GroupSummary::filterExpression))
            .setter(setter(Builder::filterExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()).build();

    private static final SdkField<InsightsConfiguration> INSIGHTS_CONFIGURATION_FIELD = SdkField
            .<InsightsConfiguration> builder(MarshallingType.SDK_POJO).memberName("InsightsConfiguration")
            .getter(getter(GroupSummary::insightsConfiguration)).setter(setter(Builder::insightsConfiguration))
            .constructor(InsightsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightsConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            GROUP_ARN_FIELD, FILTER_EXPRESSION_FIELD, INSIGHTS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final String groupARN;

    private final String filterExpression;

    private final InsightsConfiguration insightsConfiguration;

    private GroupSummary(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.groupARN = builder.groupARN;
        this.filterExpression = builder.filterExpression;
        this.insightsConfiguration = builder.insightsConfiguration;
    }

    /**
     * <p>
     * The unique case-sensitive name of the group.
     * </p>
     * 
     * @return The unique case-sensitive name of the group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The ARN of the group generated based on the GroupName.
     * </p>
     * 
     * @return The ARN of the group generated based on the GroupName.
     */
    public final String groupARN() {
        return groupARN;
    }

    /**
     * <p>
     * The filter expression defining the parameters to include traces.
     * </p>
     * 
     * @return The filter expression defining the parameters to include traces.
     */
    public final String filterExpression() {
        return filterExpression;
    }

    /**
     * <p>
     * The structure containing configurations related to insights.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for
     * the group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The NotificationsEnabled boolean can be set to true to enable insights notifications. Notifications can only be
     * enabled on a group with InsightsEnabled set to true.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The structure containing configurations related to insights.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable
     *         insights for the group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The NotificationsEnabled boolean can be set to true to enable insights notifications. Notifications can
     *         only be enabled on a group with InsightsEnabled set to true.
     *         </p>
     *         </li>
     */
    public final InsightsConfiguration insightsConfiguration() {
        return insightsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupARN());
        hashCode = 31 * hashCode + Objects.hashCode(filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(insightsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupSummary)) {
            return false;
        }
        GroupSummary other = (GroupSummary) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(groupARN(), other.groupARN())
                && Objects.equals(filterExpression(), other.filterExpression())
                && Objects.equals(insightsConfiguration(), other.insightsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupSummary").add("GroupName", groupName()).add("GroupARN", groupARN())
                .add("FilterExpression", filterExpression()).add("InsightsConfiguration", insightsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "GroupARN":
            return Optional.ofNullable(clazz.cast(groupARN()));
        case "FilterExpression":
            return Optional.ofNullable(clazz.cast(filterExpression()));
        case "InsightsConfiguration":
            return Optional.ofNullable(clazz.cast(insightsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("GroupARN", GROUP_ARN_FIELD);
        map.put("FilterExpression", FILTER_EXPRESSION_FIELD);
        map.put("InsightsConfiguration", INSIGHTS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupSummary, T> g) {
        return obj -> g.apply((GroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupSummary> {
        /**
         * <p>
         * The unique case-sensitive name of the group.
         * </p>
         * 
         * @param groupName
         *        The unique case-sensitive name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The ARN of the group generated based on the GroupName.
         * </p>
         * 
         * @param groupARN
         *        The ARN of the group generated based on the GroupName.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupARN(String groupARN);

        /**
         * <p>
         * The filter expression defining the parameters to include traces.
         * </p>
         * 
         * @param filterExpression
         *        The filter expression defining the parameters to include traces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpression(String filterExpression);

        /**
         * <p>
         * The structure containing configurations related to insights.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights
         * for the group.
         * </p>
         * </li>
         * <li>
         * <p>
         * The NotificationsEnabled boolean can be set to true to enable insights notifications. Notifications can only
         * be enabled on a group with InsightsEnabled set to true.
         * </p>
         * </li>
         * </ul>
         * 
         * @param insightsConfiguration
         *        The structure containing configurations related to insights.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable
         *        insights for the group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The NotificationsEnabled boolean can be set to true to enable insights notifications. Notifications
         *        can only be enabled on a group with InsightsEnabled set to true.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightsConfiguration(InsightsConfiguration insightsConfiguration);

        /**
         * <p>
         * The structure containing configurations related to insights.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights
         * for the group.
         * </p>
         * </li>
         * <li>
         * <p>
         * The NotificationsEnabled boolean can be set to true to enable insights notifications. Notifications can only
         * be enabled on a group with InsightsEnabled set to true.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link InsightsConfiguration.Builder} avoiding
         * the need to create one manually via {@link InsightsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsightsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #insightsConfiguration(InsightsConfiguration)}.
         * 
         * @param insightsConfiguration
         *        a consumer that will call methods on {@link InsightsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightsConfiguration(InsightsConfiguration)
         */
        default Builder insightsConfiguration(Consumer<InsightsConfiguration.Builder> insightsConfiguration) {
            return insightsConfiguration(InsightsConfiguration.builder().applyMutation(insightsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String groupARN;

        private String filterExpression;

        private InsightsConfiguration insightsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupSummary model) {
            groupName(model.groupName);
            groupARN(model.groupARN);
            filterExpression(model.filterExpression);
            insightsConfiguration(model.insightsConfiguration);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroupARN() {
            return groupARN;
        }

        public final void setGroupARN(String groupARN) {
            this.groupARN = groupARN;
        }

        @Override
        public final Builder groupARN(String groupARN) {
            this.groupARN = groupARN;
            return this;
        }

        public final String getFilterExpression() {
            return filterExpression;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final InsightsConfiguration.Builder getInsightsConfiguration() {
            return insightsConfiguration != null ? insightsConfiguration.toBuilder() : null;
        }

        public final void setInsightsConfiguration(InsightsConfiguration.BuilderImpl insightsConfiguration) {
            this.insightsConfiguration = insightsConfiguration != null ? insightsConfiguration.build() : null;
        }

        @Override
        public final Builder insightsConfiguration(InsightsConfiguration insightsConfiguration) {
            this.insightsConfiguration = insightsConfiguration;
            return this;
        }

        @Override
        public GroupSummary build() {
            return new GroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
