/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The indexing rule configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexingRuleValue implements SdkPojo, Serializable,
        ToCopyableBuilder<IndexingRuleValue.Builder, IndexingRuleValue> {
    private static final SdkField<ProbabilisticRuleValue> PROBABILISTIC_FIELD = SdkField
            .<ProbabilisticRuleValue> builder(MarshallingType.SDK_POJO).memberName("Probabilistic")
            .getter(getter(IndexingRuleValue::probabilistic)).setter(setter(Builder::probabilistic))
            .constructor(ProbabilisticRuleValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Probabilistic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROBABILISTIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProbabilisticRuleValue probabilistic;

    private final Type type;

    private IndexingRuleValue(BuilderImpl builder) {
        this.probabilistic = builder.probabilistic;
        this.type = builder.type;
    }

    /**
     * <p>
     * Indexing rule configuration that is used to probabilistically sample traceIds.
     * </p>
     * 
     * @return Indexing rule configuration that is used to probabilistically sample traceIds.
     */
    public final ProbabilisticRuleValue probabilistic() {
        return probabilistic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(probabilistic());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexingRuleValue)) {
            return false;
        }
        IndexingRuleValue other = (IndexingRuleValue) obj;
        return Objects.equals(probabilistic(), other.probabilistic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexingRuleValue").add("Probabilistic", probabilistic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Probabilistic":
            return Optional.ofNullable(clazz.cast(probabilistic()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #probabilistic()} initialized to the given value.
     *
     * <p>
     * Indexing rule configuration that is used to probabilistically sample traceIds.
     * </p>
     * 
     * @param probabilistic
     *        Indexing rule configuration that is used to probabilistically sample traceIds.
     */
    public static IndexingRuleValue fromProbabilistic(ProbabilisticRuleValue probabilistic) {
        return builder().probabilistic(probabilistic).build();
    }

    /**
     * Create an instance of this class with {@link #probabilistic()} initialized to the given value.
     *
     * <p>
     * Indexing rule configuration that is used to probabilistically sample traceIds.
     * </p>
     * 
     * @param probabilistic
     *        Indexing rule configuration that is used to probabilistically sample traceIds.
     */
    public static IndexingRuleValue fromProbabilistic(Consumer<ProbabilisticRuleValue.Builder> probabilistic) {
        ProbabilisticRuleValue.Builder builder = ProbabilisticRuleValue.builder();
        probabilistic.accept(builder);
        return fromProbabilistic(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Probabilistic", PROBABILISTIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexingRuleValue, T> g) {
        return obj -> g.apply((IndexingRuleValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexingRuleValue> {
        /**
         * <p>
         * Indexing rule configuration that is used to probabilistically sample traceIds.
         * </p>
         * 
         * @param probabilistic
         *        Indexing rule configuration that is used to probabilistically sample traceIds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder probabilistic(ProbabilisticRuleValue probabilistic);

        /**
         * <p>
         * Indexing rule configuration that is used to probabilistically sample traceIds.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProbabilisticRuleValue.Builder} avoiding
         * the need to create one manually via {@link ProbabilisticRuleValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProbabilisticRuleValue.Builder#build()} is called immediately and
         * its result is passed to {@link #probabilistic(ProbabilisticRuleValue)}.
         * 
         * @param probabilistic
         *        a consumer that will call methods on {@link ProbabilisticRuleValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #probabilistic(ProbabilisticRuleValue)
         */
        default Builder probabilistic(Consumer<ProbabilisticRuleValue.Builder> probabilistic) {
            return probabilistic(ProbabilisticRuleValue.builder().applyMutation(probabilistic).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProbabilisticRuleValue probabilistic;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IndexingRuleValue model) {
            probabilistic(model.probabilistic);
        }

        public final ProbabilisticRuleValue.Builder getProbabilistic() {
            return probabilistic != null ? probabilistic.toBuilder() : null;
        }

        public final void setProbabilistic(ProbabilisticRuleValue.BuilderImpl probabilistic) {
            Object oldValue = this.probabilistic;
            this.probabilistic = probabilistic != null ? probabilistic.build() : null;
            handleUnionValueChange(Type.PROBABILISTIC, oldValue, this.probabilistic);
        }

        @Override
        public final Builder probabilistic(ProbabilisticRuleValue probabilistic) {
            Object oldValue = this.probabilistic;
            this.probabilistic = probabilistic;
            handleUnionValueChange(Type.PROBABILISTIC, oldValue, this.probabilistic);
            return this;
        }

        @Override
        public IndexingRuleValue build() {
            return new IndexingRuleValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IndexingRuleValue#type()
     */
    public enum Type {
        PROBABILISTIC,

        UNKNOWN_TO_SDK_VERSION
    }
}
