/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTraceRetrievalRequest extends XRayRequest implements
        ToCopyableBuilder<StartTraceRetrievalRequest.Builder, StartTraceRetrievalRequest> {
    private static final SdkField<List<String>> TRACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TraceIds")
            .getter(getter(StartTraceRetrievalRequest::traceIds))
            .setter(setter(Builder::traceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(StartTraceRetrievalRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(StartTraceRetrievalRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_IDS_FIELD,
            START_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> traceIds;

    private final Instant startTime;

    private final Instant endTime;

    private StartTraceRetrievalRequest(BuilderImpl builder) {
        super(builder);
        this.traceIds = builder.traceIds;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the TraceIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTraceIds() {
        return traceIds != null && !(traceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the trace IDs of the traces to be retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTraceIds} method.
     * </p>
     * 
     * @return Specify the trace IDs of the traces to be retrieved.
     */
    public final List<String> traceIds() {
        return traceIds;
    }

    /**
     * <p>
     * The start of the time range to retrieve traces. The range is inclusive, so the specified start time is included
     * in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
     * </p>
     * 
     * @return The start of the time range to retrieve traces. The range is inclusive, so the specified start time is
     *         included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00
     *         UTC.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time range to retrieve traces. The range is inclusive, so the specified end time is included in
     * the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
     * </p>
     * 
     * @return The end of the time range to retrieve traces. The range is inclusive, so the specified end time is
     *         included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00
     *         UTC.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTraceIds() ? traceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTraceRetrievalRequest)) {
            return false;
        }
        StartTraceRetrievalRequest other = (StartTraceRetrievalRequest) obj;
        return hasTraceIds() == other.hasTraceIds() && Objects.equals(traceIds(), other.traceIds())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTraceRetrievalRequest").add("TraceIds", hasTraceIds() ? traceIds() : null)
                .add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TraceIds":
            return Optional.ofNullable(clazz.cast(traceIds()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TraceIds", TRACE_IDS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTraceRetrievalRequest, T> g) {
        return obj -> g.apply((StartTraceRetrievalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartTraceRetrievalRequest> {
        /**
         * <p>
         * Specify the trace IDs of the traces to be retrieved.
         * </p>
         * 
         * @param traceIds
         *        Specify the trace IDs of the traces to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceIds(Collection<String> traceIds);

        /**
         * <p>
         * Specify the trace IDs of the traces to be retrieved.
         * </p>
         * 
         * @param traceIds
         *        Specify the trace IDs of the traces to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceIds(String... traceIds);

        /**
         * <p>
         * The start of the time range to retrieve traces. The range is inclusive, so the specified start time is
         * included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
         * </p>
         * 
         * @param startTime
         *        The start of the time range to retrieve traces. The range is inclusive, so the specified start time is
         *        included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00
         *        UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time range to retrieve traces. The range is inclusive, so the specified end time is included
         * in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.
         * </p>
         * 
         * @param endTime
         *        The end of the time range to retrieve traces. The range is inclusive, so the specified end time is
         *        included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00
         *        UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private List<String> traceIds = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTraceRetrievalRequest model) {
            super(model);
            traceIds(model.traceIds);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final Collection<String> getTraceIds() {
            if (traceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return traceIds;
        }

        public final void setTraceIds(Collection<String> traceIds) {
            this.traceIds = TraceIdListForRetrievalCopier.copy(traceIds);
        }

        @Override
        public final Builder traceIds(Collection<String> traceIds) {
            this.traceIds = TraceIdListForRetrievalCopier.copy(traceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceIds(String... traceIds) {
            traceIds(Arrays.asList(traceIds));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTraceRetrievalRequest build() {
            return new StartTraceRetrievalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
