/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIndexingRuleRequest extends XRayRequest implements
        ToCopyableBuilder<UpdateIndexingRuleRequest.Builder, UpdateIndexingRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateIndexingRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<IndexingRuleValueUpdate> RULE_FIELD = SdkField
            .<IndexingRuleValueUpdate> builder(MarshallingType.SDK_POJO).memberName("Rule")
            .getter(getter(UpdateIndexingRuleRequest::rule)).setter(setter(Builder::rule))
            .constructor(IndexingRuleValueUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final IndexingRuleValueUpdate rule;

    private UpdateIndexingRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.rule = builder.rule;
    }

    /**
     * <p>
     * Name of the indexing rule to be updated.
     * </p>
     * 
     * @return Name of the indexing rule to be updated.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Rule configuration to be updated.
     * </p>
     * 
     * @return Rule configuration to be updated.
     */
    public final IndexingRuleValueUpdate rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIndexingRuleRequest)) {
            return false;
        }
        UpdateIndexingRuleRequest other = (UpdateIndexingRuleRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(rule(), other.rule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIndexingRuleRequest").add("Name", name()).add("Rule", rule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Rule", RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIndexingRuleRequest, T> g) {
        return obj -> g.apply((UpdateIndexingRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIndexingRuleRequest> {
        /**
         * <p>
         * Name of the indexing rule to be updated.
         * </p>
         * 
         * @param name
         *        Name of the indexing rule to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Rule configuration to be updated.
         * </p>
         * 
         * @param rule
         *        Rule configuration to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(IndexingRuleValueUpdate rule);

        /**
         * <p>
         * Rule configuration to be updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexingRuleValueUpdate.Builder} avoiding
         * the need to create one manually via {@link IndexingRuleValueUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndexingRuleValueUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #rule(IndexingRuleValueUpdate)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link IndexingRuleValueUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(IndexingRuleValueUpdate)
         */
        default Builder rule(Consumer<IndexingRuleValueUpdate.Builder> rule) {
            return rule(IndexingRuleValueUpdate.builder().applyMutation(rule).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private String name;

        private IndexingRuleValueUpdate rule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIndexingRuleRequest model) {
            super(model);
            name(model.name);
            rule(model.rule);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final IndexingRuleValueUpdate.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(IndexingRuleValueUpdate.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(IndexingRuleValueUpdate rule) {
            this.rule = rule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIndexingRuleRequest build() {
            return new UpdateIndexingRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
