/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIndexingRuleResponse extends XRayResponse implements
        ToCopyableBuilder<UpdateIndexingRuleResponse.Builder, UpdateIndexingRuleResponse> {
    private static final SdkField<IndexingRule> INDEXING_RULE_FIELD = SdkField.<IndexingRule> builder(MarshallingType.SDK_POJO)
            .memberName("IndexingRule").getter(getter(UpdateIndexingRuleResponse::indexingRule))
            .setter(setter(Builder::indexingRule)).constructor(IndexingRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexingRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEXING_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IndexingRule indexingRule;

    private UpdateIndexingRuleResponse(BuilderImpl builder) {
        super(builder);
        this.indexingRule = builder.indexingRule;
    }

    /**
     * <p>
     * Updated indexing rule.
     * </p>
     * 
     * @return Updated indexing rule.
     */
    public final IndexingRule indexingRule() {
        return indexingRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexingRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIndexingRuleResponse)) {
            return false;
        }
        UpdateIndexingRuleResponse other = (UpdateIndexingRuleResponse) obj;
        return Objects.equals(indexingRule(), other.indexingRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIndexingRuleResponse").add("IndexingRule", indexingRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexingRule":
            return Optional.ofNullable(clazz.cast(indexingRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexingRule", INDEXING_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIndexingRuleResponse, T> g) {
        return obj -> g.apply((UpdateIndexingRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIndexingRuleResponse> {
        /**
         * <p>
         * Updated indexing rule.
         * </p>
         * 
         * @param indexingRule
         *        Updated indexing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexingRule(IndexingRule indexingRule);

        /**
         * <p>
         * Updated indexing rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexingRule.Builder} avoiding the need
         * to create one manually via {@link IndexingRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndexingRule.Builder#build()} is called immediately and its
         * result is passed to {@link #indexingRule(IndexingRule)}.
         * 
         * @param indexingRule
         *        a consumer that will call methods on {@link IndexingRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexingRule(IndexingRule)
         */
        default Builder indexingRule(Consumer<IndexingRule.Builder> indexingRule) {
            return indexingRule(IndexingRule.builder().applyMutation(indexingRule).build());
        }
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private IndexingRule indexingRule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIndexingRuleResponse model) {
            super(model);
            indexingRule(model.indexingRule);
        }

        public final IndexingRule.Builder getIndexingRule() {
            return indexingRule != null ? indexingRule.toBuilder() : null;
        }

        public final void setIndexingRule(IndexingRule.BuilderImpl indexingRule) {
            this.indexingRule = indexingRule != null ? indexingRule.build() : null;
        }

        @Override
        public final Builder indexingRule(IndexingRule indexingRule) {
            this.indexingRule = indexingRule;
            return this;
        }

        @Override
        public UpdateIndexingRuleResponse build() {
            return new UpdateIndexingRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
