/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.TraceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GraphLink
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GraphLink> {
    private static final SdkField<String> REFERENCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReferenceType").getter(GraphLink.getter(GraphLink::referenceType)).setter(GraphLink.setter(Builder::referenceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceType").build()}).build();
    private static final SdkField<String> SOURCE_TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceTraceId").getter(GraphLink.getter(GraphLink::sourceTraceId)).setter(GraphLink.setter(Builder::sourceTraceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTraceId").build()}).build();
    private static final SdkField<List<String>> DESTINATION_TRACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationTraceIds").getter(GraphLink.getter(GraphLink::destinationTraceIds)).setter(GraphLink.setter(Builder::destinationTraceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTraceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_TYPE_FIELD, SOURCE_TRACE_ID_FIELD, DESTINATION_TRACE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GraphLink.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String referenceType;
    private final String sourceTraceId;
    private final List<String> destinationTraceIds;

    private GraphLink(BuilderImpl builder) {
        this.referenceType = builder.referenceType;
        this.sourceTraceId = builder.sourceTraceId;
        this.destinationTraceIds = builder.destinationTraceIds;
    }

    public final String referenceType() {
        return this.referenceType;
    }

    public final String sourceTraceId() {
        return this.sourceTraceId;
    }

    public final boolean hasDestinationTraceIds() {
        return this.destinationTraceIds != null && !(this.destinationTraceIds instanceof SdkAutoConstructList);
    }

    public final List<String> destinationTraceIds() {
        return this.destinationTraceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTraceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationTraceIds() ? this.destinationTraceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphLink)) {
            return false;
        }
        GraphLink other = (GraphLink)obj;
        return Objects.equals(this.referenceType(), other.referenceType()) && Objects.equals(this.sourceTraceId(), other.sourceTraceId()) && this.hasDestinationTraceIds() == other.hasDestinationTraceIds() && Objects.equals(this.destinationTraceIds(), other.destinationTraceIds());
    }

    public final String toString() {
        return ToString.builder((String)"GraphLink").add("ReferenceType", (Object)this.referenceType()).add("SourceTraceId", (Object)this.sourceTraceId()).add("DestinationTraceIds", this.hasDestinationTraceIds() ? this.destinationTraceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceType": {
                return Optional.ofNullable(clazz.cast(this.referenceType()));
            }
            case "SourceTraceId": {
                return Optional.ofNullable(clazz.cast(this.sourceTraceId()));
            }
            case "DestinationTraceIds": {
                return Optional.ofNullable(clazz.cast(this.destinationTraceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReferenceType", REFERENCE_TYPE_FIELD);
        map.put("SourceTraceId", SOURCE_TRACE_ID_FIELD);
        map.put("DestinationTraceIds", DESTINATION_TRACE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GraphLink, T> g) {
        return obj -> g.apply((GraphLink)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String referenceType;
        private String sourceTraceId;
        private List<String> destinationTraceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GraphLink model) {
            this.referenceType(model.referenceType);
            this.sourceTraceId(model.sourceTraceId);
            this.destinationTraceIds(model.destinationTraceIds);
        }

        public final String getReferenceType() {
            return this.referenceType;
        }

        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        public final String getSourceTraceId() {
            return this.sourceTraceId;
        }

        public final void setSourceTraceId(String sourceTraceId) {
            this.sourceTraceId = sourceTraceId;
        }

        @Override
        public final Builder sourceTraceId(String sourceTraceId) {
            this.sourceTraceId = sourceTraceId;
            return this;
        }

        public final Collection<String> getDestinationTraceIds() {
            if (this.destinationTraceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationTraceIds;
        }

        public final void setDestinationTraceIds(Collection<String> destinationTraceIds) {
            this.destinationTraceIds = TraceIdListCopier.copy(destinationTraceIds);
        }

        @Override
        public final Builder destinationTraceIds(Collection<String> destinationTraceIds) {
            this.destinationTraceIds = TraceIdListCopier.copy(destinationTraceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationTraceIds(String ... destinationTraceIds) {
            this.destinationTraceIds(Arrays.asList(destinationTraceIds));
            return this;
        }

        public GraphLink build() {
            return new GraphLink(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GraphLink> {
        public Builder referenceType(String var1);

        public Builder sourceTraceId(String var1);

        public Builder destinationTraceIds(Collection<String> var1);

        public Builder destinationTraceIds(String ... var1);
    }
}

