/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response statistics for an edge.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeStatistics implements SdkPojo, Serializable, ToCopyableBuilder<EdgeStatistics.Builder, EdgeStatistics> {
    private static final SdkField<Long> OK_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("OkCount")
            .getter(getter(EdgeStatistics::okCount)).setter(setter(Builder::okCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OkCount").build()).build();

    private static final SdkField<ErrorStatistics> ERROR_STATISTICS_FIELD = SdkField
            .<ErrorStatistics> builder(MarshallingType.SDK_POJO).memberName("ErrorStatistics")
            .getter(getter(EdgeStatistics::errorStatistics)).setter(setter(Builder::errorStatistics))
            .constructor(ErrorStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorStatistics").build()).build();

    private static final SdkField<FaultStatistics> FAULT_STATISTICS_FIELD = SdkField
            .<FaultStatistics> builder(MarshallingType.SDK_POJO).memberName("FaultStatistics")
            .getter(getter(EdgeStatistics::faultStatistics)).setter(setter(Builder::faultStatistics))
            .constructor(FaultStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultStatistics").build()).build();

    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalCount").getter(getter(EdgeStatistics::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final SdkField<Double> TOTAL_RESPONSE_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalResponseTime").getter(getter(EdgeStatistics::totalResponseTime))
            .setter(setter(Builder::totalResponseTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalResponseTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OK_COUNT_FIELD,
            ERROR_STATISTICS_FIELD, FAULT_STATISTICS_FIELD, TOTAL_COUNT_FIELD, TOTAL_RESPONSE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long okCount;

    private final ErrorStatistics errorStatistics;

    private final FaultStatistics faultStatistics;

    private final Long totalCount;

    private final Double totalResponseTime;

    private EdgeStatistics(BuilderImpl builder) {
        this.okCount = builder.okCount;
        this.errorStatistics = builder.errorStatistics;
        this.faultStatistics = builder.faultStatistics;
        this.totalCount = builder.totalCount;
        this.totalResponseTime = builder.totalResponseTime;
    }

    /**
     * <p>
     * The number of requests that completed with a 2xx Success status code.
     * </p>
     * 
     * @return The number of requests that completed with a 2xx Success status code.
     */
    public final Long okCount() {
        return okCount;
    }

    /**
     * <p>
     * Information about requests that failed with a 4xx Client Error status code.
     * </p>
     * 
     * @return Information about requests that failed with a 4xx Client Error status code.
     */
    public final ErrorStatistics errorStatistics() {
        return errorStatistics;
    }

    /**
     * <p>
     * Information about requests that failed with a 5xx Server Error status code.
     * </p>
     * 
     * @return Information about requests that failed with a 5xx Server Error status code.
     */
    public final FaultStatistics faultStatistics() {
        return faultStatistics;
    }

    /**
     * <p>
     * The total number of completed requests.
     * </p>
     * 
     * @return The total number of completed requests.
     */
    public final Long totalCount() {
        return totalCount;
    }

    /**
     * <p>
     * The aggregate response time of completed requests.
     * </p>
     * 
     * @return The aggregate response time of completed requests.
     */
    public final Double totalResponseTime() {
        return totalResponseTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(okCount());
        hashCode = 31 * hashCode + Objects.hashCode(errorStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(faultStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalResponseTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeStatistics)) {
            return false;
        }
        EdgeStatistics other = (EdgeStatistics) obj;
        return Objects.equals(okCount(), other.okCount()) && Objects.equals(errorStatistics(), other.errorStatistics())
                && Objects.equals(faultStatistics(), other.faultStatistics()) && Objects.equals(totalCount(), other.totalCount())
                && Objects.equals(totalResponseTime(), other.totalResponseTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeStatistics").add("OkCount", okCount()).add("ErrorStatistics", errorStatistics())
                .add("FaultStatistics", faultStatistics()).add("TotalCount", totalCount())
                .add("TotalResponseTime", totalResponseTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OkCount":
            return Optional.ofNullable(clazz.cast(okCount()));
        case "ErrorStatistics":
            return Optional.ofNullable(clazz.cast(errorStatistics()));
        case "FaultStatistics":
            return Optional.ofNullable(clazz.cast(faultStatistics()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        case "TotalResponseTime":
            return Optional.ofNullable(clazz.cast(totalResponseTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OkCount", OK_COUNT_FIELD);
        map.put("ErrorStatistics", ERROR_STATISTICS_FIELD);
        map.put("FaultStatistics", FAULT_STATISTICS_FIELD);
        map.put("TotalCount", TOTAL_COUNT_FIELD);
        map.put("TotalResponseTime", TOTAL_RESPONSE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgeStatistics, T> g) {
        return obj -> g.apply((EdgeStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeStatistics> {
        /**
         * <p>
         * The number of requests that completed with a 2xx Success status code.
         * </p>
         * 
         * @param okCount
         *        The number of requests that completed with a 2xx Success status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okCount(Long okCount);

        /**
         * <p>
         * Information about requests that failed with a 4xx Client Error status code.
         * </p>
         * 
         * @param errorStatistics
         *        Information about requests that failed with a 4xx Client Error status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorStatistics(ErrorStatistics errorStatistics);

        /**
         * <p>
         * Information about requests that failed with a 4xx Client Error status code.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorStatistics.Builder} avoiding the
         * need to create one manually via {@link ErrorStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #errorStatistics(ErrorStatistics)}.
         * 
         * @param errorStatistics
         *        a consumer that will call methods on {@link ErrorStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorStatistics(ErrorStatistics)
         */
        default Builder errorStatistics(Consumer<ErrorStatistics.Builder> errorStatistics) {
            return errorStatistics(ErrorStatistics.builder().applyMutation(errorStatistics).build());
        }

        /**
         * <p>
         * Information about requests that failed with a 5xx Server Error status code.
         * </p>
         * 
         * @param faultStatistics
         *        Information about requests that failed with a 5xx Server Error status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultStatistics(FaultStatistics faultStatistics);

        /**
         * <p>
         * Information about requests that failed with a 5xx Server Error status code.
         * </p>
         * This is a convenience method that creates an instance of the {@link FaultStatistics.Builder} avoiding the
         * need to create one manually via {@link FaultStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FaultStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #faultStatistics(FaultStatistics)}.
         * 
         * @param faultStatistics
         *        a consumer that will call methods on {@link FaultStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faultStatistics(FaultStatistics)
         */
        default Builder faultStatistics(Consumer<FaultStatistics.Builder> faultStatistics) {
            return faultStatistics(FaultStatistics.builder().applyMutation(faultStatistics).build());
        }

        /**
         * <p>
         * The total number of completed requests.
         * </p>
         * 
         * @param totalCount
         *        The total number of completed requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Long totalCount);

        /**
         * <p>
         * The aggregate response time of completed requests.
         * </p>
         * 
         * @param totalResponseTime
         *        The aggregate response time of completed requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResponseTime(Double totalResponseTime);
    }

    static final class BuilderImpl implements Builder {
        private Long okCount;

        private ErrorStatistics errorStatistics;

        private FaultStatistics faultStatistics;

        private Long totalCount;

        private Double totalResponseTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeStatistics model) {
            okCount(model.okCount);
            errorStatistics(model.errorStatistics);
            faultStatistics(model.faultStatistics);
            totalCount(model.totalCount);
            totalResponseTime(model.totalResponseTime);
        }

        public final Long getOkCount() {
            return okCount;
        }

        public final void setOkCount(Long okCount) {
            this.okCount = okCount;
        }

        @Override
        public final Builder okCount(Long okCount) {
            this.okCount = okCount;
            return this;
        }

        public final ErrorStatistics.Builder getErrorStatistics() {
            return errorStatistics != null ? errorStatistics.toBuilder() : null;
        }

        public final void setErrorStatistics(ErrorStatistics.BuilderImpl errorStatistics) {
            this.errorStatistics = errorStatistics != null ? errorStatistics.build() : null;
        }

        @Override
        public final Builder errorStatistics(ErrorStatistics errorStatistics) {
            this.errorStatistics = errorStatistics;
            return this;
        }

        public final FaultStatistics.Builder getFaultStatistics() {
            return faultStatistics != null ? faultStatistics.toBuilder() : null;
        }

        public final void setFaultStatistics(FaultStatistics.BuilderImpl faultStatistics) {
            this.faultStatistics = faultStatistics != null ? faultStatistics.build() : null;
        }

        @Override
        public final Builder faultStatistics(FaultStatistics faultStatistics) {
            this.faultStatistics = faultStatistics;
            return this;
        }

        public final Long getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final Double getTotalResponseTime() {
            return totalResponseTime;
        }

        public final void setTotalResponseTime(Double totalResponseTime) {
            this.totalResponseTime = totalResponseTime;
        }

        @Override
        public final Builder totalResponseTime(Double totalResponseTime) {
            this.totalResponseTime = totalResponseTime;
            return this;
        }

        @Override
        public EdgeStatistics build() {
            return new EdgeStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
