/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Rule used to determine the server-side sampling rate for spans ingested through the CloudWatchLogs destination and
 * indexed by X-Ray.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexingRule implements SdkPojo, Serializable, ToCopyableBuilder<IndexingRule.Builder, IndexingRule> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(IndexingRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt").getter(getter(IndexingRule::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()).build();

    private static final SdkField<IndexingRuleValue> RULE_FIELD = SdkField.<IndexingRuleValue> builder(MarshallingType.SDK_POJO)
            .memberName("Rule").getter(getter(IndexingRule::rule)).setter(setter(Builder::rule))
            .constructor(IndexingRuleValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MODIFIED_AT_FIELD,
            RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Instant modifiedAt;

    private final IndexingRuleValue rule;

    private IndexingRule(BuilderImpl builder) {
        this.name = builder.name;
        this.modifiedAt = builder.modifiedAt;
        this.rule = builder.rule;
    }

    /**
     * <p>
     * The name of the indexing rule.
     * </p>
     * 
     * @return The name of the indexing rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Displays when the rule was last modified, in Unix time seconds.
     * </p>
     * 
     * @return Displays when the rule was last modified, in Unix time seconds.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The indexing rule.
     * </p>
     * 
     * @return The indexing rule.
     */
    public final IndexingRuleValue rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexingRule)) {
            return false;
        }
        IndexingRule other = (IndexingRule) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(rule(), other.rule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexingRule").add("Name", name()).add("ModifiedAt", modifiedAt()).add("Rule", rule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("Rule", RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexingRule, T> g) {
        return obj -> g.apply((IndexingRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexingRule> {
        /**
         * <p>
         * The name of the indexing rule.
         * </p>
         * 
         * @param name
         *        The name of the indexing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Displays when the rule was last modified, in Unix time seconds.
         * </p>
         * 
         * @param modifiedAt
         *        Displays when the rule was last modified, in Unix time seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The indexing rule.
         * </p>
         * 
         * @param rule
         *        The indexing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(IndexingRuleValue rule);

        /**
         * <p>
         * The indexing rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexingRuleValue.Builder} avoiding the
         * need to create one manually via {@link IndexingRuleValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndexingRuleValue.Builder#build()} is called immediately and its
         * result is passed to {@link #rule(IndexingRuleValue)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link IndexingRuleValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(IndexingRuleValue)
         */
        default Builder rule(Consumer<IndexingRuleValue.Builder> rule) {
            return rule(IndexingRuleValue.builder().applyMutation(rule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Instant modifiedAt;

        private IndexingRuleValue rule;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexingRule model) {
            name(model.name);
            modifiedAt(model.modifiedAt);
            rule(model.rule);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final IndexingRuleValue.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(IndexingRuleValue.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(IndexingRuleValue rule) {
            this.rule = rule;
            return this;
        }

        @Override
        public IndexingRule build() {
            return new IndexingRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
