/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRetrievedTracesResponse extends XRayResponse implements
        ToCopyableBuilder<ListRetrievedTracesResponse.Builder, ListRetrievedTracesResponse> {
    private static final SdkField<String> RETRIEVAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrievalStatus").getter(getter(ListRetrievedTracesResponse::retrievalStatusAsString))
            .setter(setter(Builder::retrievalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalStatus").build()).build();

    private static final SdkField<String> TRACE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TraceFormat").getter(getter(ListRetrievedTracesResponse::traceFormatAsString))
            .setter(setter(Builder::traceFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceFormat").build()).build();

    private static final SdkField<List<RetrievedTrace>> TRACES_FIELD = SdkField
            .<List<RetrievedTrace>> builder(MarshallingType.LIST)
            .memberName("Traces")
            .getter(getter(ListRetrievedTracesResponse::traces))
            .setter(setter(Builder::traces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetrievedTrace> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetrievedTrace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRetrievedTracesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVAL_STATUS_FIELD,
            TRACE_FORMAT_FIELD, TRACES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String retrievalStatus;

    private final String traceFormat;

    private final List<RetrievedTrace> traces;

    private final String nextToken;

    private ListRetrievedTracesResponse(BuilderImpl builder) {
        super(builder);
        this.retrievalStatus = builder.retrievalStatus;
        this.traceFormat = builder.traceFormat;
        this.traces = builder.traces;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Status of the retrieval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retrievalStatus}
     * will return {@link RetrievalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retrievalStatusAsString}.
     * </p>
     * 
     * @return Status of the retrieval.
     * @see RetrievalStatus
     */
    public final RetrievalStatus retrievalStatus() {
        return RetrievalStatus.fromValue(retrievalStatus);
    }

    /**
     * <p>
     * Status of the retrieval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retrievalStatus}
     * will return {@link RetrievalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retrievalStatusAsString}.
     * </p>
     * 
     * @return Status of the retrieval.
     * @see RetrievalStatus
     */
    public final String retrievalStatusAsString() {
        return retrievalStatus;
    }

    /**
     * <p>
     * Format of the requested traces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #traceFormat} will
     * return {@link TraceFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceFormatAsString}.
     * </p>
     * 
     * @return Format of the requested traces.
     * @see TraceFormatType
     */
    public final TraceFormatType traceFormat() {
        return TraceFormatType.fromValue(traceFormat);
    }

    /**
     * <p>
     * Format of the requested traces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #traceFormat} will
     * return {@link TraceFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceFormatAsString}.
     * </p>
     * 
     * @return Format of the requested traces.
     * @see TraceFormatType
     */
    public final String traceFormatAsString() {
        return traceFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the Traces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTraces() {
        return traces != null && !(traces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Full traces for the specified requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTraces} method.
     * </p>
     * 
     * @return Full traces for the specified requests.
     */
    public final List<RetrievedTrace> traces() {
        return traces;
    }

    /**
     * <p>
     * Specify the pagination token returned by a previous request to retrieve the next page of indexes.
     * </p>
     * 
     * @return Specify the pagination token returned by a previous request to retrieve the next page of indexes.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(retrievalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(traceFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTraces() ? traces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetrievedTracesResponse)) {
            return false;
        }
        ListRetrievedTracesResponse other = (ListRetrievedTracesResponse) obj;
        return Objects.equals(retrievalStatusAsString(), other.retrievalStatusAsString())
                && Objects.equals(traceFormatAsString(), other.traceFormatAsString()) && hasTraces() == other.hasTraces()
                && Objects.equals(traces(), other.traces()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRetrievedTracesResponse").add("RetrievalStatus", retrievalStatusAsString())
                .add("TraceFormat", traceFormatAsString()).add("Traces", hasTraces() ? traces() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetrievalStatus":
            return Optional.ofNullable(clazz.cast(retrievalStatusAsString()));
        case "TraceFormat":
            return Optional.ofNullable(clazz.cast(traceFormatAsString()));
        case "Traces":
            return Optional.ofNullable(clazz.cast(traces()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RetrievalStatus", RETRIEVAL_STATUS_FIELD);
        map.put("TraceFormat", TRACE_FORMAT_FIELD);
        map.put("Traces", TRACES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRetrievedTracesResponse, T> g) {
        return obj -> g.apply((ListRetrievedTracesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRetrievedTracesResponse> {
        /**
         * <p>
         * Status of the retrieval.
         * </p>
         * 
         * @param retrievalStatus
         *        Status of the retrieval.
         * @see RetrievalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalStatus
         */
        Builder retrievalStatus(String retrievalStatus);

        /**
         * <p>
         * Status of the retrieval.
         * </p>
         * 
         * @param retrievalStatus
         *        Status of the retrieval.
         * @see RetrievalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalStatus
         */
        Builder retrievalStatus(RetrievalStatus retrievalStatus);

        /**
         * <p>
         * Format of the requested traces.
         * </p>
         * 
         * @param traceFormat
         *        Format of the requested traces.
         * @see TraceFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraceFormatType
         */
        Builder traceFormat(String traceFormat);

        /**
         * <p>
         * Format of the requested traces.
         * </p>
         * 
         * @param traceFormat
         *        Format of the requested traces.
         * @see TraceFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraceFormatType
         */
        Builder traceFormat(TraceFormatType traceFormat);

        /**
         * <p>
         * Full traces for the specified requests.
         * </p>
         * 
         * @param traces
         *        Full traces for the specified requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traces(Collection<RetrievedTrace> traces);

        /**
         * <p>
         * Full traces for the specified requests.
         * </p>
         * 
         * @param traces
         *        Full traces for the specified requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traces(RetrievedTrace... traces);

        /**
         * <p>
         * Full traces for the specified requests.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.RetrievedTrace.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.xray.model.RetrievedTrace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.RetrievedTrace.Builder#build()} is called immediately and
         * its result is passed to {@link #traces(List<RetrievedTrace>)}.
         * 
         * @param traces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.RetrievedTrace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traces(java.util.Collection<RetrievedTrace>)
         */
        Builder traces(Consumer<RetrievedTrace.Builder>... traces);

        /**
         * <p>
         * Specify the pagination token returned by a previous request to retrieve the next page of indexes.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token returned by a previous request to retrieve the next page of indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private String retrievalStatus;

        private String traceFormat;

        private List<RetrievedTrace> traces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetrievedTracesResponse model) {
            super(model);
            retrievalStatus(model.retrievalStatus);
            traceFormat(model.traceFormat);
            traces(model.traces);
            nextToken(model.nextToken);
        }

        public final String getRetrievalStatus() {
            return retrievalStatus;
        }

        public final void setRetrievalStatus(String retrievalStatus) {
            this.retrievalStatus = retrievalStatus;
        }

        @Override
        public final Builder retrievalStatus(String retrievalStatus) {
            this.retrievalStatus = retrievalStatus;
            return this;
        }

        @Override
        public final Builder retrievalStatus(RetrievalStatus retrievalStatus) {
            this.retrievalStatus(retrievalStatus == null ? null : retrievalStatus.toString());
            return this;
        }

        public final String getTraceFormat() {
            return traceFormat;
        }

        public final void setTraceFormat(String traceFormat) {
            this.traceFormat = traceFormat;
        }

        @Override
        public final Builder traceFormat(String traceFormat) {
            this.traceFormat = traceFormat;
            return this;
        }

        @Override
        public final Builder traceFormat(TraceFormatType traceFormat) {
            this.traceFormat(traceFormat == null ? null : traceFormat.toString());
            return this;
        }

        public final List<RetrievedTrace.Builder> getTraces() {
            List<RetrievedTrace.Builder> result = TraceSpanListCopier.copyToBuilder(this.traces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraces(Collection<RetrievedTrace.BuilderImpl> traces) {
            this.traces = TraceSpanListCopier.copyFromBuilder(traces);
        }

        @Override
        public final Builder traces(Collection<RetrievedTrace> traces) {
            this.traces = TraceSpanListCopier.copy(traces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traces(RetrievedTrace... traces) {
            traces(Arrays.asList(traces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traces(Consumer<RetrievedTrace.Builder>... traces) {
            traces(Stream.of(traces).map(c -> RetrievedTrace.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRetrievedTracesResponse build() {
            return new ListRetrievedTracesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
