/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Update to the indexing rule configuration for probabilistic sampling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProbabilisticRuleValueUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ProbabilisticRuleValueUpdate.Builder, ProbabilisticRuleValueUpdate> {
    private static final SdkField<Double> DESIRED_SAMPLING_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DesiredSamplingPercentage").getter(getter(ProbabilisticRuleValueUpdate::desiredSamplingPercentage))
            .setter(setter(Builder::desiredSamplingPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredSamplingPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DESIRED_SAMPLING_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double desiredSamplingPercentage;

    private ProbabilisticRuleValueUpdate(BuilderImpl builder) {
        this.desiredSamplingPercentage = builder.desiredSamplingPercentage;
    }

    /**
     * <p>
     * Configured sampling percentage of traceIds. Note that sampling can be subject to limits to ensure completeness of
     * data.
     * </p>
     * 
     * @return Configured sampling percentage of traceIds. Note that sampling can be subject to limits to ensure
     *         completeness of data.
     */
    public final Double desiredSamplingPercentage() {
        return desiredSamplingPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredSamplingPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProbabilisticRuleValueUpdate)) {
            return false;
        }
        ProbabilisticRuleValueUpdate other = (ProbabilisticRuleValueUpdate) obj;
        return Objects.equals(desiredSamplingPercentage(), other.desiredSamplingPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProbabilisticRuleValueUpdate").add("DesiredSamplingPercentage", desiredSamplingPercentage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DesiredSamplingPercentage":
            return Optional.ofNullable(clazz.cast(desiredSamplingPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DesiredSamplingPercentage", DESIRED_SAMPLING_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProbabilisticRuleValueUpdate, T> g) {
        return obj -> g.apply((ProbabilisticRuleValueUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProbabilisticRuleValueUpdate> {
        /**
         * <p>
         * Configured sampling percentage of traceIds. Note that sampling can be subject to limits to ensure
         * completeness of data.
         * </p>
         * 
         * @param desiredSamplingPercentage
         *        Configured sampling percentage of traceIds. Note that sampling can be subject to limits to ensure
         *        completeness of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredSamplingPercentage(Double desiredSamplingPercentage);
    }

    static final class BuilderImpl implements Builder {
        private Double desiredSamplingPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(ProbabilisticRuleValueUpdate model) {
            desiredSamplingPercentage(model.desiredSamplingPercentage);
        }

        public final Double getDesiredSamplingPercentage() {
            return desiredSamplingPercentage;
        }

        public final void setDesiredSamplingPercentage(Double desiredSamplingPercentage) {
            this.desiredSamplingPercentage = desiredSamplingPercentage;
        }

        @Override
        public final Builder desiredSamplingPercentage(Double desiredSamplingPercentage) {
            this.desiredSamplingPercentage = desiredSamplingPercentage;
            return this;
        }

        @Override
        public ProbabilisticRuleValueUpdate build() {
            return new ProbabilisticRuleValueUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
