/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of TimeSeriesStatistic structures.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesServiceStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesServiceStatistics.Builder, TimeSeriesServiceStatistics> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(TimeSeriesServiceStatistics::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<EdgeStatistics> EDGE_SUMMARY_STATISTICS_FIELD = SdkField
            .<EdgeStatistics> builder(MarshallingType.SDK_POJO).memberName("EdgeSummaryStatistics")
            .getter(getter(TimeSeriesServiceStatistics::edgeSummaryStatistics)).setter(setter(Builder::edgeSummaryStatistics))
            .constructor(EdgeStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeSummaryStatistics").build())
            .build();

    private static final SdkField<ServiceStatistics> SERVICE_SUMMARY_STATISTICS_FIELD = SdkField
            .<ServiceStatistics> builder(MarshallingType.SDK_POJO).memberName("ServiceSummaryStatistics")
            .getter(getter(TimeSeriesServiceStatistics::serviceSummaryStatistics))
            .setter(setter(Builder::serviceSummaryStatistics)).constructor(ServiceStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSummaryStatistics").build())
            .build();

    private static final SdkField<ForecastStatistics> SERVICE_FORECAST_STATISTICS_FIELD = SdkField
            .<ForecastStatistics> builder(MarshallingType.SDK_POJO).memberName("ServiceForecastStatistics")
            .getter(getter(TimeSeriesServiceStatistics::serviceForecastStatistics))
            .setter(setter(Builder::serviceForecastStatistics)).constructor(ForecastStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceForecastStatistics").build())
            .build();

    private static final SdkField<List<HistogramEntry>> RESPONSE_TIME_HISTOGRAM_FIELD = SdkField
            .<List<HistogramEntry>> builder(MarshallingType.LIST)
            .memberName("ResponseTimeHistogram")
            .getter(getter(TimeSeriesServiceStatistics::responseTimeHistogram))
            .setter(setter(Builder::responseTimeHistogram))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTimeHistogram").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HistogramEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(HistogramEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            EDGE_SUMMARY_STATISTICS_FIELD, SERVICE_SUMMARY_STATISTICS_FIELD, SERVICE_FORECAST_STATISTICS_FIELD,
            RESPONSE_TIME_HISTOGRAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final EdgeStatistics edgeSummaryStatistics;

    private final ServiceStatistics serviceSummaryStatistics;

    private final ForecastStatistics serviceForecastStatistics;

    private final List<HistogramEntry> responseTimeHistogram;

    private TimeSeriesServiceStatistics(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.edgeSummaryStatistics = builder.edgeSummaryStatistics;
        this.serviceSummaryStatistics = builder.serviceSummaryStatistics;
        this.serviceForecastStatistics = builder.serviceForecastStatistics;
        this.responseTimeHistogram = builder.responseTimeHistogram;
    }

    /**
     * <p>
     * Timestamp of the window for which statistics are aggregated.
     * </p>
     * 
     * @return Timestamp of the window for which statistics are aggregated.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * Returns the value of the EdgeSummaryStatistics property for this object.
     * 
     * @return The value of the EdgeSummaryStatistics property for this object.
     */
    public final EdgeStatistics edgeSummaryStatistics() {
        return edgeSummaryStatistics;
    }

    /**
     * Returns the value of the ServiceSummaryStatistics property for this object.
     * 
     * @return The value of the ServiceSummaryStatistics property for this object.
     */
    public final ServiceStatistics serviceSummaryStatistics() {
        return serviceSummaryStatistics;
    }

    /**
     * <p>
     * The forecasted high and low fault count values.
     * </p>
     * 
     * @return The forecasted high and low fault count values.
     */
    public final ForecastStatistics serviceForecastStatistics() {
        return serviceForecastStatistics;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseTimeHistogram property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResponseTimeHistogram() {
        return responseTimeHistogram != null && !(responseTimeHistogram instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The response time histogram for the selected entities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseTimeHistogram} method.
     * </p>
     * 
     * @return The response time histogram for the selected entities.
     */
    public final List<HistogramEntry> responseTimeHistogram() {
        return responseTimeHistogram;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(edgeSummaryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSummaryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(serviceForecastStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseTimeHistogram() ? responseTimeHistogram() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesServiceStatistics)) {
            return false;
        }
        TimeSeriesServiceStatistics other = (TimeSeriesServiceStatistics) obj;
        return Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(edgeSummaryStatistics(), other.edgeSummaryStatistics())
                && Objects.equals(serviceSummaryStatistics(), other.serviceSummaryStatistics())
                && Objects.equals(serviceForecastStatistics(), other.serviceForecastStatistics())
                && hasResponseTimeHistogram() == other.hasResponseTimeHistogram()
                && Objects.equals(responseTimeHistogram(), other.responseTimeHistogram());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesServiceStatistics").add("Timestamp", timestamp())
                .add("EdgeSummaryStatistics", edgeSummaryStatistics())
                .add("ServiceSummaryStatistics", serviceSummaryStatistics())
                .add("ServiceForecastStatistics", serviceForecastStatistics())
                .add("ResponseTimeHistogram", hasResponseTimeHistogram() ? responseTimeHistogram() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "EdgeSummaryStatistics":
            return Optional.ofNullable(clazz.cast(edgeSummaryStatistics()));
        case "ServiceSummaryStatistics":
            return Optional.ofNullable(clazz.cast(serviceSummaryStatistics()));
        case "ServiceForecastStatistics":
            return Optional.ofNullable(clazz.cast(serviceForecastStatistics()));
        case "ResponseTimeHistogram":
            return Optional.ofNullable(clazz.cast(responseTimeHistogram()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("EdgeSummaryStatistics", EDGE_SUMMARY_STATISTICS_FIELD);
        map.put("ServiceSummaryStatistics", SERVICE_SUMMARY_STATISTICS_FIELD);
        map.put("ServiceForecastStatistics", SERVICE_FORECAST_STATISTICS_FIELD);
        map.put("ResponseTimeHistogram", RESPONSE_TIME_HISTOGRAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesServiceStatistics, T> g) {
        return obj -> g.apply((TimeSeriesServiceStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesServiceStatistics> {
        /**
         * <p>
         * Timestamp of the window for which statistics are aggregated.
         * </p>
         * 
         * @param timestamp
         *        Timestamp of the window for which statistics are aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * Sets the value of the EdgeSummaryStatistics property for this object.
         *
         * @param edgeSummaryStatistics
         *        The new value for the EdgeSummaryStatistics property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeSummaryStatistics(EdgeStatistics edgeSummaryStatistics);

        /**
         * Sets the value of the EdgeSummaryStatistics property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EdgeStatistics.Builder} avoiding the need
         * to create one manually via {@link EdgeStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdgeStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #edgeSummaryStatistics(EdgeStatistics)}.
         * 
         * @param edgeSummaryStatistics
         *        a consumer that will call methods on {@link EdgeStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edgeSummaryStatistics(EdgeStatistics)
         */
        default Builder edgeSummaryStatistics(Consumer<EdgeStatistics.Builder> edgeSummaryStatistics) {
            return edgeSummaryStatistics(EdgeStatistics.builder().applyMutation(edgeSummaryStatistics).build());
        }

        /**
         * Sets the value of the ServiceSummaryStatistics property for this object.
         *
         * @param serviceSummaryStatistics
         *        The new value for the ServiceSummaryStatistics property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSummaryStatistics(ServiceStatistics serviceSummaryStatistics);

        /**
         * Sets the value of the ServiceSummaryStatistics property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ServiceStatistics.Builder} avoiding the
         * need to create one manually via {@link ServiceStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceSummaryStatistics(ServiceStatistics)}.
         * 
         * @param serviceSummaryStatistics
         *        a consumer that will call methods on {@link ServiceStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSummaryStatistics(ServiceStatistics)
         */
        default Builder serviceSummaryStatistics(Consumer<ServiceStatistics.Builder> serviceSummaryStatistics) {
            return serviceSummaryStatistics(ServiceStatistics.builder().applyMutation(serviceSummaryStatistics).build());
        }

        /**
         * <p>
         * The forecasted high and low fault count values.
         * </p>
         * 
         * @param serviceForecastStatistics
         *        The forecasted high and low fault count values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceForecastStatistics(ForecastStatistics serviceForecastStatistics);

        /**
         * <p>
         * The forecasted high and low fault count values.
         * </p>
         * This is a convenience method that creates an instance of the {@link ForecastStatistics.Builder} avoiding the
         * need to create one manually via {@link ForecastStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ForecastStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceForecastStatistics(ForecastStatistics)}.
         * 
         * @param serviceForecastStatistics
         *        a consumer that will call methods on {@link ForecastStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceForecastStatistics(ForecastStatistics)
         */
        default Builder serviceForecastStatistics(Consumer<ForecastStatistics.Builder> serviceForecastStatistics) {
            return serviceForecastStatistics(ForecastStatistics.builder().applyMutation(serviceForecastStatistics).build());
        }

        /**
         * <p>
         * The response time histogram for the selected entities.
         * </p>
         * 
         * @param responseTimeHistogram
         *        The response time histogram for the selected entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram);

        /**
         * <p>
         * The response time histogram for the selected entities.
         * </p>
         * 
         * @param responseTimeHistogram
         *        The response time histogram for the selected entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTimeHistogram(HistogramEntry... responseTimeHistogram);

        /**
         * <p>
         * The response time histogram for the selected entities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.HistogramEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.xray.model.HistogramEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.HistogramEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #responseTimeHistogram(List<HistogramEntry>)}.
         * 
         * @param responseTimeHistogram
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.HistogramEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseTimeHistogram(java.util.Collection<HistogramEntry>)
         */
        Builder responseTimeHistogram(Consumer<HistogramEntry.Builder>... responseTimeHistogram);
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private EdgeStatistics edgeSummaryStatistics;

        private ServiceStatistics serviceSummaryStatistics;

        private ForecastStatistics serviceForecastStatistics;

        private List<HistogramEntry> responseTimeHistogram = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesServiceStatistics model) {
            timestamp(model.timestamp);
            edgeSummaryStatistics(model.edgeSummaryStatistics);
            serviceSummaryStatistics(model.serviceSummaryStatistics);
            serviceForecastStatistics(model.serviceForecastStatistics);
            responseTimeHistogram(model.responseTimeHistogram);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final EdgeStatistics.Builder getEdgeSummaryStatistics() {
            return edgeSummaryStatistics != null ? edgeSummaryStatistics.toBuilder() : null;
        }

        public final void setEdgeSummaryStatistics(EdgeStatistics.BuilderImpl edgeSummaryStatistics) {
            this.edgeSummaryStatistics = edgeSummaryStatistics != null ? edgeSummaryStatistics.build() : null;
        }

        @Override
        public final Builder edgeSummaryStatistics(EdgeStatistics edgeSummaryStatistics) {
            this.edgeSummaryStatistics = edgeSummaryStatistics;
            return this;
        }

        public final ServiceStatistics.Builder getServiceSummaryStatistics() {
            return serviceSummaryStatistics != null ? serviceSummaryStatistics.toBuilder() : null;
        }

        public final void setServiceSummaryStatistics(ServiceStatistics.BuilderImpl serviceSummaryStatistics) {
            this.serviceSummaryStatistics = serviceSummaryStatistics != null ? serviceSummaryStatistics.build() : null;
        }

        @Override
        public final Builder serviceSummaryStatistics(ServiceStatistics serviceSummaryStatistics) {
            this.serviceSummaryStatistics = serviceSummaryStatistics;
            return this;
        }

        public final ForecastStatistics.Builder getServiceForecastStatistics() {
            return serviceForecastStatistics != null ? serviceForecastStatistics.toBuilder() : null;
        }

        public final void setServiceForecastStatistics(ForecastStatistics.BuilderImpl serviceForecastStatistics) {
            this.serviceForecastStatistics = serviceForecastStatistics != null ? serviceForecastStatistics.build() : null;
        }

        @Override
        public final Builder serviceForecastStatistics(ForecastStatistics serviceForecastStatistics) {
            this.serviceForecastStatistics = serviceForecastStatistics;
            return this;
        }

        public final List<HistogramEntry.Builder> getResponseTimeHistogram() {
            List<HistogramEntry.Builder> result = HistogramCopier.copyToBuilder(this.responseTimeHistogram);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponseTimeHistogram(Collection<HistogramEntry.BuilderImpl> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copyFromBuilder(responseTimeHistogram);
        }

        @Override
        public final Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copy(responseTimeHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(HistogramEntry... responseTimeHistogram) {
            responseTimeHistogram(Arrays.asList(responseTimeHistogram));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(Consumer<HistogramEntry.Builder>... responseTimeHistogram) {
            responseTimeHistogram(Stream.of(responseTimeHistogram).map(c -> HistogramEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TimeSeriesServiceStatistics build() {
            return new TimeSeriesServiceStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
