/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.FaultRootCauseService;
import software.amazon.awssdk.services.xray.model.FaultRootCauseServicesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FaultRootCause
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FaultRootCause> {
    private static final SdkField<List<FaultRootCauseService>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Services").getter(FaultRootCause.getter(FaultRootCause::services)).setter(FaultRootCause.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FaultRootCauseService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CLIENT_IMPACTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ClientImpacting").getter(FaultRootCause.getter(FaultRootCause::clientImpacting)).setter(FaultRootCause.setter(Builder::clientImpacting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientImpacting").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD, CLIENT_IMPACTING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FaultRootCause.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FaultRootCauseService> services;
    private final Boolean clientImpacting;

    private FaultRootCause(BuilderImpl builder) {
        this.services = builder.services;
        this.clientImpacting = builder.clientImpacting;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<FaultRootCauseService> services() {
        return this.services;
    }

    public final Boolean clientImpacting() {
        return this.clientImpacting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientImpacting());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaultRootCause)) {
            return false;
        }
        FaultRootCause other = (FaultRootCause)obj;
        return this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services()) && Objects.equals(this.clientImpacting(), other.clientImpacting());
    }

    public final String toString() {
        return ToString.builder((String)"FaultRootCause").add("Services", this.hasServices() ? this.services() : null).add("ClientImpacting", (Object)this.clientImpacting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "ClientImpacting": {
                return Optional.ofNullable(clazz.cast(this.clientImpacting()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Services", SERVICES_FIELD);
        map.put("ClientImpacting", CLIENT_IMPACTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FaultRootCause, T> g) {
        return obj -> g.apply((FaultRootCause)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FaultRootCauseService> services = DefaultSdkAutoConstructList.getInstance();
        private Boolean clientImpacting;

        private BuilderImpl() {
        }

        private BuilderImpl(FaultRootCause model) {
            this.services(model.services);
            this.clientImpacting(model.clientImpacting);
        }

        public final List<FaultRootCauseService.Builder> getServices() {
            List<FaultRootCauseService.Builder> result = FaultRootCauseServicesCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<FaultRootCauseService.BuilderImpl> services) {
            this.services = FaultRootCauseServicesCopier.copyFromBuilder(services);
        }

        @Override
        public final Builder services(Collection<FaultRootCauseService> services) {
            this.services = FaultRootCauseServicesCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(FaultRootCauseService ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<FaultRootCauseService.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (FaultRootCauseService)((FaultRootCauseService.Builder)FaultRootCauseService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getClientImpacting() {
            return this.clientImpacting;
        }

        public final void setClientImpacting(Boolean clientImpacting) {
            this.clientImpacting = clientImpacting;
        }

        @Override
        public final Builder clientImpacting(Boolean clientImpacting) {
            this.clientImpacting = clientImpacting;
            return this;
        }

        public FaultRootCause build() {
            return new FaultRootCause(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FaultRootCause> {
        public Builder services(Collection<FaultRootCauseService> var1);

        public Builder services(FaultRootCauseService ... var1);

        public Builder services(Consumer<FaultRootCauseService.Builder> ... var1);

        public Builder clientImpacting(Boolean var1);
    }
}

