/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.XRayServiceClientConfiguration;
import software.amazon.awssdk.services.xray.internal.XRayServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.xray.model.BatchGetTracesRequest;
import software.amazon.awssdk.services.xray.model.BatchGetTracesResponse;
import software.amazon.awssdk.services.xray.model.CancelTraceRetrievalRequest;
import software.amazon.awssdk.services.xray.model.CancelTraceRetrievalResponse;
import software.amazon.awssdk.services.xray.model.CreateGroupRequest;
import software.amazon.awssdk.services.xray.model.CreateGroupResponse;
import software.amazon.awssdk.services.xray.model.CreateSamplingRuleRequest;
import software.amazon.awssdk.services.xray.model.CreateSamplingRuleResponse;
import software.amazon.awssdk.services.xray.model.DeleteGroupRequest;
import software.amazon.awssdk.services.xray.model.DeleteGroupResponse;
import software.amazon.awssdk.services.xray.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.xray.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest;
import software.amazon.awssdk.services.xray.model.DeleteSamplingRuleResponse;
import software.amazon.awssdk.services.xray.model.GetEncryptionConfigRequest;
import software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse;
import software.amazon.awssdk.services.xray.model.GetGroupRequest;
import software.amazon.awssdk.services.xray.model.GetGroupResponse;
import software.amazon.awssdk.services.xray.model.GetGroupsRequest;
import software.amazon.awssdk.services.xray.model.GetGroupsResponse;
import software.amazon.awssdk.services.xray.model.GetIndexingRulesRequest;
import software.amazon.awssdk.services.xray.model.GetIndexingRulesResponse;
import software.amazon.awssdk.services.xray.model.GetInsightEventsRequest;
import software.amazon.awssdk.services.xray.model.GetInsightEventsResponse;
import software.amazon.awssdk.services.xray.model.GetInsightImpactGraphRequest;
import software.amazon.awssdk.services.xray.model.GetInsightImpactGraphResponse;
import software.amazon.awssdk.services.xray.model.GetInsightRequest;
import software.amazon.awssdk.services.xray.model.GetInsightResponse;
import software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetInsightSummariesResponse;
import software.amazon.awssdk.services.xray.model.GetRetrievedTracesGraphRequest;
import software.amazon.awssdk.services.xray.model.GetRetrievedTracesGraphResponse;
import software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse;
import software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse;
import software.amazon.awssdk.services.xray.model.GetSamplingTargetsRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingTargetsResponse;
import software.amazon.awssdk.services.xray.model.GetServiceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetServiceGraphResponse;
import software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest;
import software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsResponse;
import software.amazon.awssdk.services.xray.model.GetTraceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetTraceGraphResponse;
import software.amazon.awssdk.services.xray.model.GetTraceSegmentDestinationRequest;
import software.amazon.awssdk.services.xray.model.GetTraceSegmentDestinationResponse;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse;
import software.amazon.awssdk.services.xray.model.InvalidPolicyRevisionIdException;
import software.amazon.awssdk.services.xray.model.InvalidRequestException;
import software.amazon.awssdk.services.xray.model.ListResourcePoliciesRequest;
import software.amazon.awssdk.services.xray.model.ListResourcePoliciesResponse;
import software.amazon.awssdk.services.xray.model.ListRetrievedTracesRequest;
import software.amazon.awssdk.services.xray.model.ListRetrievedTracesResponse;
import software.amazon.awssdk.services.xray.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.xray.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.xray.model.LockoutPreventionException;
import software.amazon.awssdk.services.xray.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.xray.model.PolicyCountLimitExceededException;
import software.amazon.awssdk.services.xray.model.PolicySizeLimitExceededException;
import software.amazon.awssdk.services.xray.model.PutEncryptionConfigRequest;
import software.amazon.awssdk.services.xray.model.PutEncryptionConfigResponse;
import software.amazon.awssdk.services.xray.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.xray.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest;
import software.amazon.awssdk.services.xray.model.PutTelemetryRecordsResponse;
import software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest;
import software.amazon.awssdk.services.xray.model.PutTraceSegmentsResponse;
import software.amazon.awssdk.services.xray.model.ResourceNotFoundException;
import software.amazon.awssdk.services.xray.model.RuleLimitExceededException;
import software.amazon.awssdk.services.xray.model.StartTraceRetrievalRequest;
import software.amazon.awssdk.services.xray.model.StartTraceRetrievalResponse;
import software.amazon.awssdk.services.xray.model.TagResourceRequest;
import software.amazon.awssdk.services.xray.model.TagResourceResponse;
import software.amazon.awssdk.services.xray.model.ThrottledException;
import software.amazon.awssdk.services.xray.model.TooManyTagsException;
import software.amazon.awssdk.services.xray.model.UntagResourceRequest;
import software.amazon.awssdk.services.xray.model.UntagResourceResponse;
import software.amazon.awssdk.services.xray.model.UpdateGroupRequest;
import software.amazon.awssdk.services.xray.model.UpdateGroupResponse;
import software.amazon.awssdk.services.xray.model.UpdateIndexingRuleRequest;
import software.amazon.awssdk.services.xray.model.UpdateIndexingRuleResponse;
import software.amazon.awssdk.services.xray.model.UpdateSamplingRuleRequest;
import software.amazon.awssdk.services.xray.model.UpdateSamplingRuleResponse;
import software.amazon.awssdk.services.xray.model.UpdateTraceSegmentDestinationRequest;
import software.amazon.awssdk.services.xray.model.UpdateTraceSegmentDestinationResponse;
import software.amazon.awssdk.services.xray.model.XRayException;
import software.amazon.awssdk.services.xray.transform.BatchGetTracesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.CancelTraceRetrievalRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.CreateSamplingRuleRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.DeleteSamplingRuleRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetGroupsRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetIndexingRulesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetInsightEventsRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetInsightImpactGraphRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetInsightRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetInsightSummariesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetRetrievedTracesGraphRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetSamplingRulesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetSamplingStatisticSummariesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetSamplingTargetsRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetServiceGraphRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetTimeSeriesServiceStatisticsRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetTraceGraphRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetTraceSegmentDestinationRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.GetTraceSummariesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.ListResourcePoliciesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.ListRetrievedTracesRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.PutEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.PutTelemetryRecordsRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.PutTraceSegmentsRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.StartTraceRetrievalRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.UpdateIndexingRuleRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.UpdateSamplingRuleRequestMarshaller;
import software.amazon.awssdk.services.xray.transform.UpdateTraceSegmentDestinationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultXRayClient
implements XRayClient {
    private static final Logger log = Logger.loggerFor(DefaultXRayClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultXRayClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"XRay#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetTracesResponse batchGetTraces(BatchGetTracesRequest batchGetTracesRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetTracesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetTracesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, batchGetTracesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetTraces");
            BatchGetTracesResponse batchGetTracesResponse = (BatchGetTracesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetTraces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetTracesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetTracesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetTracesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$batchGetTraces$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelTraceRetrievalResponse cancelTraceRetrieval(CancelTraceRetrievalRequest cancelTraceRetrievalRequest) throws InvalidRequestException, ThrottledException, ResourceNotFoundException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelTraceRetrievalResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelTraceRetrievalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, cancelTraceRetrievalRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelTraceRetrieval");
            CancelTraceRetrievalResponse cancelTraceRetrievalResponse = (CancelTraceRetrievalResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelTraceRetrieval").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelTraceRetrievalRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelTraceRetrievalRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelTraceRetrievalResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$cancelTraceRetrieval$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, createGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGroup");
            CreateGroupResponse createGroupResponse = (CreateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$createGroup$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSamplingRuleResponse createSamplingRule(CreateSamplingRuleRequest createSamplingRuleRequest) throws InvalidRequestException, ThrottledException, RuleLimitExceededException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSamplingRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSamplingRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, createSamplingRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSamplingRule");
            CreateSamplingRuleResponse createSamplingRuleResponse = (CreateSamplingRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSamplingRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSamplingRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSamplingRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSamplingRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$createSamplingRule$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, deleteGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGroup");
            DeleteGroupResponse deleteGroupResponse = (DeleteGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$deleteGroup$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws InvalidRequestException, InvalidPolicyRevisionIdException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$deleteResourcePolicy$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSamplingRuleResponse deleteSamplingRule(DeleteSamplingRuleRequest deleteSamplingRuleRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSamplingRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSamplingRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, deleteSamplingRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSamplingRule");
            DeleteSamplingRuleResponse deleteSamplingRuleResponse = (DeleteSamplingRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSamplingRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSamplingRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSamplingRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSamplingRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$deleteSamplingRule$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEncryptionConfigResponse getEncryptionConfig(GetEncryptionConfigRequest getEncryptionConfigRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEncryptionConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEncryptionConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getEncryptionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEncryptionConfig");
            GetEncryptionConfigResponse getEncryptionConfigResponse = (GetEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEncryptionConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEncryptionConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEncryptionConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEncryptionConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getEncryptionConfig$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGroupResponse getGroup(GetGroupRequest getGroupRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGroup");
            GetGroupResponse getGroupResponse = (GetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getGroup$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGroupsResponse getGroups(GetGroupsRequest getGroupsRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGroups");
            GetGroupsResponse getGroupsResponse = (GetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getGroups$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIndexingRulesResponse getIndexingRules(GetIndexingRulesRequest getIndexingRulesRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIndexingRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIndexingRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getIndexingRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIndexingRules");
            GetIndexingRulesResponse getIndexingRulesResponse = (GetIndexingRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIndexingRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getIndexingRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIndexingRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIndexingRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getIndexingRules$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInsightResponse getInsight(GetInsightRequest getInsightRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInsightResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInsightRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getInsightRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInsight");
            GetInsightResponse getInsightResponse = (GetInsightResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsight").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInsightRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInsightRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInsightResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getInsight$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInsightEventsResponse getInsightEvents(GetInsightEventsRequest getInsightEventsRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInsightEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInsightEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getInsightEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInsightEvents");
            GetInsightEventsResponse getInsightEventsResponse = (GetInsightEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsightEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInsightEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInsightEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInsightEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getInsightEvents$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInsightImpactGraphResponse getInsightImpactGraph(GetInsightImpactGraphRequest getInsightImpactGraphRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInsightImpactGraphResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInsightImpactGraphRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getInsightImpactGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInsightImpactGraph");
            GetInsightImpactGraphResponse getInsightImpactGraphResponse = (GetInsightImpactGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsightImpactGraph").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInsightImpactGraphRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInsightImpactGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInsightImpactGraphResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getInsightImpactGraph$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInsightSummariesResponse getInsightSummaries(GetInsightSummariesRequest getInsightSummariesRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInsightSummariesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInsightSummariesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getInsightSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInsightSummaries");
            GetInsightSummariesResponse getInsightSummariesResponse = (GetInsightSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsightSummaries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInsightSummariesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInsightSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInsightSummariesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getInsightSummaries$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRetrievedTracesGraphResponse getRetrievedTracesGraph(GetRetrievedTracesGraphRequest getRetrievedTracesGraphRequest) throws InvalidRequestException, ThrottledException, ResourceNotFoundException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRetrievedTracesGraphResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRetrievedTracesGraphRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getRetrievedTracesGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRetrievedTracesGraph");
            GetRetrievedTracesGraphResponse getRetrievedTracesGraphResponse = (GetRetrievedTracesGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRetrievedTracesGraph").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRetrievedTracesGraphRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRetrievedTracesGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRetrievedTracesGraphResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getRetrievedTracesGraph$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSamplingRulesResponse getSamplingRules(GetSamplingRulesRequest getSamplingRulesRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSamplingRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSamplingRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getSamplingRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSamplingRules");
            GetSamplingRulesResponse getSamplingRulesResponse = (GetSamplingRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSamplingRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSamplingRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSamplingRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSamplingRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getSamplingRules$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSamplingStatisticSummariesResponse getSamplingStatisticSummaries(GetSamplingStatisticSummariesRequest getSamplingStatisticSummariesRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSamplingStatisticSummariesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSamplingStatisticSummariesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getSamplingStatisticSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSamplingStatisticSummaries");
            GetSamplingStatisticSummariesResponse getSamplingStatisticSummariesResponse = (GetSamplingStatisticSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSamplingStatisticSummaries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSamplingStatisticSummariesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSamplingStatisticSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSamplingStatisticSummariesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getSamplingStatisticSummaries$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSamplingTargetsResponse getSamplingTargets(GetSamplingTargetsRequest getSamplingTargetsRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSamplingTargetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSamplingTargetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getSamplingTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSamplingTargets");
            GetSamplingTargetsResponse getSamplingTargetsResponse = (GetSamplingTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSamplingTargets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSamplingTargetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSamplingTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSamplingTargetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getSamplingTargets$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceGraphResponse getServiceGraph(GetServiceGraphRequest getServiceGraphRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceGraphResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServiceGraphRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getServiceGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceGraph");
            GetServiceGraphResponse getServiceGraphResponse = (GetServiceGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceGraph").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getServiceGraphRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceGraphResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getServiceGraph$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTimeSeriesServiceStatisticsResponse getTimeSeriesServiceStatistics(GetTimeSeriesServiceStatisticsRequest getTimeSeriesServiceStatisticsRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTimeSeriesServiceStatisticsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTimeSeriesServiceStatisticsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getTimeSeriesServiceStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTimeSeriesServiceStatistics");
            GetTimeSeriesServiceStatisticsResponse getTimeSeriesServiceStatisticsResponse = (GetTimeSeriesServiceStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTimeSeriesServiceStatistics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTimeSeriesServiceStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTimeSeriesServiceStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTimeSeriesServiceStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getTimeSeriesServiceStatistics$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTraceGraphResponse getTraceGraph(GetTraceGraphRequest getTraceGraphRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTraceGraphResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTraceGraphRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getTraceGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTraceGraph");
            GetTraceGraphResponse getTraceGraphResponse = (GetTraceGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTraceGraph").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTraceGraphRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTraceGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTraceGraphResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getTraceGraph$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTraceSegmentDestinationResponse getTraceSegmentDestination(GetTraceSegmentDestinationRequest getTraceSegmentDestinationRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTraceSegmentDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTraceSegmentDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getTraceSegmentDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTraceSegmentDestination");
            GetTraceSegmentDestinationResponse getTraceSegmentDestinationResponse = (GetTraceSegmentDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTraceSegmentDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTraceSegmentDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTraceSegmentDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTraceSegmentDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getTraceSegmentDestination$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTraceSummariesResponse getTraceSummaries(GetTraceSummariesRequest getTraceSummariesRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTraceSummariesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTraceSummariesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, getTraceSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTraceSummaries");
            GetTraceSummariesResponse getTraceSummariesResponse = (GetTraceSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTraceSummaries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTraceSummariesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTraceSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTraceSummariesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$getTraceSummaries$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourcePoliciesResponse listResourcePolicies(ListResourcePoliciesRequest listResourcePoliciesRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcePoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourcePoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, listResourcePoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourcePolicies");
            ListResourcePoliciesResponse listResourcePoliciesResponse = (ListResourcePoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourcePolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResourcePoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourcePoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourcePoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$listResourcePolicies$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRetrievedTracesResponse listRetrievedTraces(ListRetrievedTracesRequest listRetrievedTracesRequest) throws InvalidRequestException, ThrottledException, ResourceNotFoundException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRetrievedTracesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRetrievedTracesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, listRetrievedTracesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRetrievedTraces");
            ListRetrievedTracesResponse listRetrievedTracesResponse = (ListRetrievedTracesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRetrievedTraces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRetrievedTracesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRetrievedTracesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRetrievedTracesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$listRetrievedTraces$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, ThrottledException, ResourceNotFoundException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$listTagsForResource$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEncryptionConfigResponse putEncryptionConfig(PutEncryptionConfigRequest putEncryptionConfigRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEncryptionConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEncryptionConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, putEncryptionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEncryptionConfig");
            PutEncryptionConfigResponse putEncryptionConfigResponse = (PutEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEncryptionConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putEncryptionConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutEncryptionConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEncryptionConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$putEncryptionConfig$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) throws MalformedPolicyDocumentException, LockoutPreventionException, InvalidPolicyRevisionIdException, PolicySizeLimitExceededException, PolicyCountLimitExceededException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            PutResourcePolicyResponse putResourcePolicyResponse = (PutResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$putResourcePolicy$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutTelemetryRecordsResponse putTelemetryRecords(PutTelemetryRecordsRequest putTelemetryRecordsRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTelemetryRecordsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putTelemetryRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, putTelemetryRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutTelemetryRecords");
            PutTelemetryRecordsResponse putTelemetryRecordsResponse = (PutTelemetryRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTelemetryRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putTelemetryRecordsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutTelemetryRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putTelemetryRecordsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$putTelemetryRecords$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutTraceSegmentsResponse putTraceSegments(PutTraceSegmentsRequest putTraceSegmentsRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTraceSegmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putTraceSegmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, putTraceSegmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutTraceSegments");
            PutTraceSegmentsResponse putTraceSegmentsResponse = (PutTraceSegmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTraceSegments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putTraceSegmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutTraceSegmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putTraceSegmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$putTraceSegments$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTraceRetrievalResponse startTraceRetrieval(StartTraceRetrievalRequest startTraceRetrievalRequest) throws InvalidRequestException, ThrottledException, ResourceNotFoundException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTraceRetrievalResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTraceRetrievalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, startTraceRetrievalRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTraceRetrieval");
            StartTraceRetrievalResponse startTraceRetrievalResponse = (StartTraceRetrievalResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTraceRetrieval").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startTraceRetrievalRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTraceRetrievalRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTraceRetrievalResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$startTraceRetrieval$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException, ThrottledException, ResourceNotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$tagResource$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException, ThrottledException, ResourceNotFoundException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$untagResource$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, updateGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGroup");
            UpdateGroupResponse updateGroupResponse = (UpdateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$updateGroup$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIndexingRuleResponse updateIndexingRule(UpdateIndexingRuleRequest updateIndexingRuleRequest) throws InvalidRequestException, ThrottledException, ResourceNotFoundException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIndexingRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateIndexingRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, updateIndexingRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIndexingRule");
            UpdateIndexingRuleResponse updateIndexingRuleResponse = (UpdateIndexingRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIndexingRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateIndexingRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateIndexingRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateIndexingRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$updateIndexingRule$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSamplingRuleResponse updateSamplingRule(UpdateSamplingRuleRequest updateSamplingRuleRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSamplingRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSamplingRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, updateSamplingRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSamplingRule");
            UpdateSamplingRuleResponse updateSamplingRuleResponse = (UpdateSamplingRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSamplingRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateSamplingRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSamplingRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSamplingRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$updateSamplingRule$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTraceSegmentDestinationResponse updateTraceSegmentDestination(UpdateTraceSegmentDestinationRequest updateTraceSegmentDestinationRequest) throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTraceSegmentDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidPolicyRevisionIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "RuleLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RuleLimitExceededException").exceptionBuilderSupplier(RuleLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "PolicyCountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyCountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyCountLimitExceededException::builder).build());
                }
                case "LockoutPreventionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventionException::builder).build());
                }
                case "PolicySizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicySizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicySizeLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTraceSegmentDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultXRayClient.resolveMetricPublishers(clientConfiguration, updateTraceSegmentDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"XRay");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTraceSegmentDestination");
            UpdateTraceSegmentDestinationResponse updateTraceSegmentDestinationResponse = (UpdateTraceSegmentDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTraceSegmentDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTraceSegmentDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTraceSegmentDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTraceSegmentDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultXRayClient.lambda$updateTraceSegmentDestination$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "xray";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        XRayServiceClientConfigurationBuilder serviceConfigBuilder = new XRayServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(XRayException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final XRayServiceClientConfiguration serviceClientConfiguration() {
        return new XRayServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTraceSegmentDestination$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSamplingRule$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateIndexingRule$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGroup$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTraceRetrieval$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putTraceSegments$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putTelemetryRecords$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEncryptionConfig$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRetrievedTraces$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourcePolicies$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTraceSummaries$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTraceSegmentDestination$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTraceGraph$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTimeSeriesServiceStatistics$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceGraph$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSamplingTargets$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSamplingStatisticSummaries$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSamplingRules$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRetrievedTracesGraph$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInsightSummaries$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInsightImpactGraph$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInsightEvents$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInsight$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIndexingRules$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGroups$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGroup$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEncryptionConfig$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSamplingRule$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGroup$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSamplingRule$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGroup$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelTraceRetrieval$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetTraces$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

