/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRetrievedTracesGraphResponse extends XRayResponse implements
        ToCopyableBuilder<GetRetrievedTracesGraphResponse.Builder, GetRetrievedTracesGraphResponse> {
    private static final SdkField<String> RETRIEVAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrievalStatus").getter(getter(GetRetrievedTracesGraphResponse::retrievalStatusAsString))
            .setter(setter(Builder::retrievalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalStatus").build()).build();

    private static final SdkField<List<RetrievedService>> SERVICES_FIELD = SdkField
            .<List<RetrievedService>> builder(MarshallingType.LIST)
            .memberName("Services")
            .getter(getter(GetRetrievedTracesGraphResponse::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetrievedService> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetrievedService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetRetrievedTracesGraphResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVAL_STATUS_FIELD,
            SERVICES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String retrievalStatus;

    private final List<RetrievedService> services;

    private final String nextToken;

    private GetRetrievedTracesGraphResponse(BuilderImpl builder) {
        super(builder);
        this.retrievalStatus = builder.retrievalStatus;
        this.services = builder.services;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Status of the retrieval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retrievalStatus}
     * will return {@link RetrievalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retrievalStatusAsString}.
     * </p>
     * 
     * @return Status of the retrieval.
     * @see RetrievalStatus
     */
    public final RetrievalStatus retrievalStatus() {
        return RetrievalStatus.fromValue(retrievalStatus);
    }

    /**
     * <p>
     * Status of the retrieval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retrievalStatus}
     * will return {@link RetrievalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retrievalStatusAsString}.
     * </p>
     * 
     * @return Status of the retrieval.
     * @see RetrievalStatus
     */
    public final String retrievalStatusAsString() {
        return retrievalStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Retrieved services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return Retrieved services.
     */
    public final List<RetrievedService> services() {
        return services;
    }

    /**
     * <p>
     * Specify the pagination token returned by a previous request to retrieve the next page of indexes.
     * </p>
     * 
     * @return Specify the pagination token returned by a previous request to retrieve the next page of indexes.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(retrievalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRetrievedTracesGraphResponse)) {
            return false;
        }
        GetRetrievedTracesGraphResponse other = (GetRetrievedTracesGraphResponse) obj;
        return Objects.equals(retrievalStatusAsString(), other.retrievalStatusAsString()) && hasServices() == other.hasServices()
                && Objects.equals(services(), other.services()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRetrievedTracesGraphResponse").add("RetrievalStatus", retrievalStatusAsString())
                .add("Services", hasServices() ? services() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetrievalStatus":
            return Optional.ofNullable(clazz.cast(retrievalStatusAsString()));
        case "Services":
            return Optional.ofNullable(clazz.cast(services()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RetrievalStatus", RETRIEVAL_STATUS_FIELD);
        map.put("Services", SERVICES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRetrievedTracesGraphResponse, T> g) {
        return obj -> g.apply((GetRetrievedTracesGraphResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRetrievedTracesGraphResponse> {
        /**
         * <p>
         * Status of the retrieval.
         * </p>
         * 
         * @param retrievalStatus
         *        Status of the retrieval.
         * @see RetrievalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalStatus
         */
        Builder retrievalStatus(String retrievalStatus);

        /**
         * <p>
         * Status of the retrieval.
         * </p>
         * 
         * @param retrievalStatus
         *        Status of the retrieval.
         * @see RetrievalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalStatus
         */
        Builder retrievalStatus(RetrievalStatus retrievalStatus);

        /**
         * <p>
         * Retrieved services.
         * </p>
         * 
         * @param services
         *        Retrieved services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<RetrievedService> services);

        /**
         * <p>
         * Retrieved services.
         * </p>
         * 
         * @param services
         *        Retrieved services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(RetrievedService... services);

        /**
         * <p>
         * Retrieved services.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.RetrievedService.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.xray.model.RetrievedService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.RetrievedService.Builder#build()} is called immediately and
         * its result is passed to {@link #services(List<RetrievedService>)}.
         * 
         * @param services
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.RetrievedService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(java.util.Collection<RetrievedService>)
         */
        Builder services(Consumer<RetrievedService.Builder>... services);

        /**
         * <p>
         * Specify the pagination token returned by a previous request to retrieve the next page of indexes.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token returned by a previous request to retrieve the next page of indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private String retrievalStatus;

        private List<RetrievedService> services = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRetrievedTracesGraphResponse model) {
            super(model);
            retrievalStatus(model.retrievalStatus);
            services(model.services);
            nextToken(model.nextToken);
        }

        public final String getRetrievalStatus() {
            return retrievalStatus;
        }

        public final void setRetrievalStatus(String retrievalStatus) {
            this.retrievalStatus = retrievalStatus;
        }

        @Override
        public final Builder retrievalStatus(String retrievalStatus) {
            this.retrievalStatus = retrievalStatus;
            return this;
        }

        @Override
        public final Builder retrievalStatus(RetrievalStatus retrievalStatus) {
            this.retrievalStatus(retrievalStatus == null ? null : retrievalStatus.toString());
            return this;
        }

        public final List<RetrievedService.Builder> getServices() {
            List<RetrievedService.Builder> result = RetrievedServicesListCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<RetrievedService.BuilderImpl> services) {
            this.services = RetrievedServicesListCopier.copyFromBuilder(services);
        }

        @Override
        public final Builder services(Collection<RetrievedService> services) {
            this.services = RetrievedServicesListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(RetrievedService... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<RetrievedService.Builder>... services) {
            services(Stream.of(services).map(c -> RetrievedService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetRetrievedTracesGraphResponse build() {
            return new GetRetrievedTracesGraphResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
