/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTraceSummariesRequest extends XRayRequest implements
        ToCopyableBuilder<GetTraceSummariesRequest.Builder, GetTraceSummariesRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(GetTraceSummariesRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(GetTraceSummariesRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> TIME_RANGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeRangeType").getter(getter(GetTraceSummariesRequest::timeRangeTypeAsString))
            .setter(setter(Builder::timeRangeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeType").build()).build();

    private static final SdkField<Boolean> SAMPLING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Sampling").getter(getter(GetTraceSummariesRequest::sampling)).setter(setter(Builder::sampling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sampling").build()).build();

    private static final SdkField<SamplingStrategy> SAMPLING_STRATEGY_FIELD = SdkField
            .<SamplingStrategy> builder(MarshallingType.SDK_POJO).memberName("SamplingStrategy")
            .getter(getter(GetTraceSummariesRequest::samplingStrategy)).setter(setter(Builder::samplingStrategy))
            .constructor(SamplingStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingStrategy").build()).build();

    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterExpression").getter(getter(GetTraceSummariesRequest::filterExpression))
            .setter(setter(Builder::filterExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetTraceSummariesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, TIME_RANGE_TYPE_FIELD, SAMPLING_FIELD, SAMPLING_STRATEGY_FIELD, FILTER_EXPRESSION_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant startTime;

    private final Instant endTime;

    private final String timeRangeType;

    private final Boolean sampling;

    private final SamplingStrategy samplingStrategy;

    private final String filterExpression;

    private final String nextToken;

    private GetTraceSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.timeRangeType = builder.timeRangeType;
        this.sampling = builder.sampling;
        this.samplingStrategy = builder.samplingStrategy;
        this.filterExpression = builder.filterExpression;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The start of the time frame for which to retrieve traces.
     * </p>
     * 
     * @return The start of the time frame for which to retrieve traces.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time frame for which to retrieve traces.
     * </p>
     * 
     * @return The end of the time frame for which to retrieve traces.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Query trace summaries by TraceId (trace start time), Event (trace update time), or Service (trace segment end
     * time).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeRangeType}
     * will return {@link TimeRangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeRangeTypeAsString}.
     * </p>
     * 
     * @return Query trace summaries by TraceId (trace start time), Event (trace update time), or Service (trace segment
     *         end time).
     * @see TimeRangeType
     */
    public final TimeRangeType timeRangeType() {
        return TimeRangeType.fromValue(timeRangeType);
    }

    /**
     * <p>
     * Query trace summaries by TraceId (trace start time), Event (trace update time), or Service (trace segment end
     * time).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeRangeType}
     * will return {@link TimeRangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeRangeTypeAsString}.
     * </p>
     * 
     * @return Query trace summaries by TraceId (trace start time), Event (trace update time), or Service (trace segment
     *         end time).
     * @see TimeRangeType
     */
    public final String timeRangeTypeAsString() {
        return timeRangeType;
    }

    /**
     * <p>
     * Set to <code>true</code> to get summaries for only a subset of available traces.
     * </p>
     * 
     * @return Set to <code>true</code> to get summaries for only a subset of available traces.
     */
    public final Boolean sampling() {
        return sampling;
    }

    /**
     * <p>
     * A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and Value.
     * </p>
     * 
     * @return A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and
     *         Value.
     */
    public final SamplingStrategy samplingStrategy() {
        return samplingStrategy;
    }

    /**
     * <p>
     * Specify a filter expression to retrieve trace summaries for services or requests that meet certain requirements.
     * </p>
     * 
     * @return Specify a filter expression to retrieve trace summaries for services or requests that meet certain
     *         requirements.
     */
    public final String filterExpression() {
        return filterExpression;
    }

    /**
     * <p>
     * Specify the pagination token returned by a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token returned by a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampling());
        hashCode = 31 * hashCode + Objects.hashCode(samplingStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceSummariesRequest)) {
            return false;
        }
        GetTraceSummariesRequest other = (GetTraceSummariesRequest) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(timeRangeTypeAsString(), other.timeRangeTypeAsString())
                && Objects.equals(sampling(), other.sampling()) && Objects.equals(samplingStrategy(), other.samplingStrategy())
                && Objects.equals(filterExpression(), other.filterExpression()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTraceSummariesRequest").add("StartTime", startTime()).add("EndTime", endTime())
                .add("TimeRangeType", timeRangeTypeAsString()).add("Sampling", sampling())
                .add("SamplingStrategy", samplingStrategy()).add("FilterExpression", filterExpression())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "TimeRangeType":
            return Optional.ofNullable(clazz.cast(timeRangeTypeAsString()));
        case "Sampling":
            return Optional.ofNullable(clazz.cast(sampling()));
        case "SamplingStrategy":
            return Optional.ofNullable(clazz.cast(samplingStrategy()));
        case "FilterExpression":
            return Optional.ofNullable(clazz.cast(filterExpression()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("TimeRangeType", TIME_RANGE_TYPE_FIELD);
        map.put("Sampling", SAMPLING_FIELD);
        map.put("SamplingStrategy", SAMPLING_STRATEGY_FIELD);
        map.put("FilterExpression", FILTER_EXPRESSION_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTraceSummariesRequest, T> g) {
        return obj -> g.apply((GetTraceSummariesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTraceSummariesRequest> {
        /**
         * <p>
         * The start of the time frame for which to retrieve traces.
         * </p>
         * 
         * @param startTime
         *        The start of the time frame for which to retrieve traces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time frame for which to retrieve traces.
         * </p>
         * 
         * @param endTime
         *        The end of the time frame for which to retrieve traces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Query trace summaries by TraceId (trace start time), Event (trace update time), or Service (trace segment end
         * time).
         * </p>
         * 
         * @param timeRangeType
         *        Query trace summaries by TraceId (trace start time), Event (trace update time), or Service (trace
         *        segment end time).
         * @see TimeRangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeRangeType
         */
        Builder timeRangeType(String timeRangeType);

        /**
         * <p>
         * Query trace summaries by TraceId (trace start time), Event (trace update time), or Service (trace segment end
         * time).
         * </p>
         * 
         * @param timeRangeType
         *        Query trace summaries by TraceId (trace start time), Event (trace update time), or Service (trace
         *        segment end time).
         * @see TimeRangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeRangeType
         */
        Builder timeRangeType(TimeRangeType timeRangeType);

        /**
         * <p>
         * Set to <code>true</code> to get summaries for only a subset of available traces.
         * </p>
         * 
         * @param sampling
         *        Set to <code>true</code> to get summaries for only a subset of available traces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampling(Boolean sampling);

        /**
         * <p>
         * A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and Value.
         * </p>
         * 
         * @param samplingStrategy
         *        A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and
         *        Value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingStrategy(SamplingStrategy samplingStrategy);

        /**
         * <p>
         * A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and Value.
         * </p>
         * This is a convenience method that creates an instance of the {@link SamplingStrategy.Builder} avoiding the
         * need to create one manually via {@link SamplingStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SamplingStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #samplingStrategy(SamplingStrategy)}.
         * 
         * @param samplingStrategy
         *        a consumer that will call methods on {@link SamplingStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samplingStrategy(SamplingStrategy)
         */
        default Builder samplingStrategy(Consumer<SamplingStrategy.Builder> samplingStrategy) {
            return samplingStrategy(SamplingStrategy.builder().applyMutation(samplingStrategy).build());
        }

        /**
         * <p>
         * Specify a filter expression to retrieve trace summaries for services or requests that meet certain
         * requirements.
         * </p>
         * 
         * @param filterExpression
         *        Specify a filter expression to retrieve trace summaries for services or requests that meet certain
         *        requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpression(String filterExpression);

        /**
         * <p>
         * Specify the pagination token returned by a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token returned by a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private String timeRangeType;

        private Boolean sampling;

        private SamplingStrategy samplingStrategy;

        private String filterExpression;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceSummariesRequest model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            timeRangeType(model.timeRangeType);
            sampling(model.sampling);
            samplingStrategy(model.samplingStrategy);
            filterExpression(model.filterExpression);
            nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getTimeRangeType() {
            return timeRangeType;
        }

        public final void setTimeRangeType(String timeRangeType) {
            this.timeRangeType = timeRangeType;
        }

        @Override
        public final Builder timeRangeType(String timeRangeType) {
            this.timeRangeType = timeRangeType;
            return this;
        }

        @Override
        public final Builder timeRangeType(TimeRangeType timeRangeType) {
            this.timeRangeType(timeRangeType == null ? null : timeRangeType.toString());
            return this;
        }

        public final Boolean getSampling() {
            return sampling;
        }

        public final void setSampling(Boolean sampling) {
            this.sampling = sampling;
        }

        @Override
        public final Builder sampling(Boolean sampling) {
            this.sampling = sampling;
            return this;
        }

        public final SamplingStrategy.Builder getSamplingStrategy() {
            return samplingStrategy != null ? samplingStrategy.toBuilder() : null;
        }

        public final void setSamplingStrategy(SamplingStrategy.BuilderImpl samplingStrategy) {
            this.samplingStrategy = samplingStrategy != null ? samplingStrategy.build() : null;
        }

        @Override
        public final Builder samplingStrategy(SamplingStrategy samplingStrategy) {
            this.samplingStrategy = samplingStrategy;
            return this;
        }

        public final String getFilterExpression() {
            return filterExpression;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTraceSummariesRequest build() {
            return new GetTraceSummariesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
