/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIndexingRulesResponse extends XRayResponse implements
        ToCopyableBuilder<GetIndexingRulesResponse.Builder, GetIndexingRulesResponse> {
    private static final SdkField<List<IndexingRule>> INDEXING_RULES_FIELD = SdkField
            .<List<IndexingRule>> builder(MarshallingType.LIST)
            .memberName("IndexingRules")
            .getter(getter(GetIndexingRulesResponse::indexingRules))
            .setter(setter(Builder::indexingRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexingRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IndexingRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(IndexingRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetIndexingRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEXING_RULES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<IndexingRule> indexingRules;

    private final String nextToken;

    private GetIndexingRulesResponse(BuilderImpl builder) {
        super(builder);
        this.indexingRules = builder.indexingRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IndexingRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIndexingRules() {
        return indexingRules != null && !(indexingRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Retrieves all indexing rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIndexingRules} method.
     * </p>
     * 
     * @return Retrieves all indexing rules.
     */
    public final List<IndexingRule> indexingRules() {
        return indexingRules;
    }

    /**
     * <p>
     * Specify the pagination token returned by a previous request to retrieve the next page of indexes.
     * </p>
     * 
     * @return Specify the pagination token returned by a previous request to retrieve the next page of indexes.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIndexingRules() ? indexingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIndexingRulesResponse)) {
            return false;
        }
        GetIndexingRulesResponse other = (GetIndexingRulesResponse) obj;
        return hasIndexingRules() == other.hasIndexingRules() && Objects.equals(indexingRules(), other.indexingRules())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIndexingRulesResponse").add("IndexingRules", hasIndexingRules() ? indexingRules() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexingRules":
            return Optional.ofNullable(clazz.cast(indexingRules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexingRules", INDEXING_RULES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIndexingRulesResponse, T> g) {
        return obj -> g.apply((GetIndexingRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIndexingRulesResponse> {
        /**
         * <p>
         * Retrieves all indexing rules.
         * </p>
         * 
         * @param indexingRules
         *        Retrieves all indexing rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexingRules(Collection<IndexingRule> indexingRules);

        /**
         * <p>
         * Retrieves all indexing rules.
         * </p>
         * 
         * @param indexingRules
         *        Retrieves all indexing rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexingRules(IndexingRule... indexingRules);

        /**
         * <p>
         * Retrieves all indexing rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.IndexingRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.xray.model.IndexingRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.IndexingRule.Builder#build()} is called immediately and its
         * result is passed to {@link #indexingRules(List<IndexingRule>)}.
         * 
         * @param indexingRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.IndexingRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexingRules(java.util.Collection<IndexingRule>)
         */
        Builder indexingRules(Consumer<IndexingRule.Builder>... indexingRules);

        /**
         * <p>
         * Specify the pagination token returned by a previous request to retrieve the next page of indexes.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token returned by a previous request to retrieve the next page of indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private List<IndexingRule> indexingRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIndexingRulesResponse model) {
            super(model);
            indexingRules(model.indexingRules);
            nextToken(model.nextToken);
        }

        public final List<IndexingRule.Builder> getIndexingRules() {
            List<IndexingRule.Builder> result = IndexingRuleListCopier.copyToBuilder(this.indexingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexingRules(Collection<IndexingRule.BuilderImpl> indexingRules) {
            this.indexingRules = IndexingRuleListCopier.copyFromBuilder(indexingRules);
        }

        @Override
        public final Builder indexingRules(Collection<IndexingRule> indexingRules) {
            this.indexingRules = IndexingRuleListCopier.copy(indexingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexingRules(IndexingRule... indexingRules) {
            indexingRules(Arrays.asList(indexingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexingRules(Consumer<IndexingRule.Builder>... indexingRules) {
            indexingRules(Stream.of(indexingRules).map(c -> IndexingRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIndexingRulesResponse build() {
            return new GetIndexingRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
