/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connection between two service in an insight impact graph.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightImpactGraphEdge implements SdkPojo, Serializable,
        ToCopyableBuilder<InsightImpactGraphEdge.Builder, InsightImpactGraphEdge> {
    private static final SdkField<Integer> REFERENCE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReferenceId").getter(getter(InsightImpactGraphEdge::referenceId)).setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer referenceId;

    private InsightImpactGraphEdge(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
    }

    /**
     * <p>
     * Identifier of the edge. Unique within a service map.
     * </p>
     * 
     * @return Identifier of the edge. Unique within a service map.
     */
    public final Integer referenceId() {
        return referenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightImpactGraphEdge)) {
            return false;
        }
        InsightImpactGraphEdge other = (InsightImpactGraphEdge) obj;
        return Objects.equals(referenceId(), other.referenceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightImpactGraphEdge").add("ReferenceId", referenceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReferenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReferenceId", REFERENCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightImpactGraphEdge, T> g) {
        return obj -> g.apply((InsightImpactGraphEdge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightImpactGraphEdge> {
        /**
         * <p>
         * Identifier of the edge. Unique within a service map.
         * </p>
         * 
         * @param referenceId
         *        Identifier of the edge. Unique within a service map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(Integer referenceId);
    }

    static final class BuilderImpl implements Builder {
        private Integer referenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightImpactGraphEdge model) {
            referenceId(model.referenceId);
        }

        public final Integer getReferenceId() {
            return referenceId;
        }

        public final void setReferenceId(Integer referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(Integer referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Override
        public InsightImpactGraphEdge build() {
            return new InsightImpactGraphEdge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
