/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enable temporary sampling rate increases when you detect anomalies to improve visibility.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamplingRateBoost implements SdkPojo, Serializable,
        ToCopyableBuilder<SamplingRateBoost.Builder, SamplingRateBoost> {
    private static final SdkField<Double> MAX_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxRate").getter(getter(SamplingRateBoost::maxRate)).setter(setter(Builder::maxRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRate").build()).build();

    private static final SdkField<Integer> COOLDOWN_WINDOW_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CooldownWindowMinutes").getter(getter(SamplingRateBoost::cooldownWindowMinutes))
            .setter(setter(Builder::cooldownWindowMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CooldownWindowMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RATE_FIELD,
            COOLDOWN_WINDOW_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double maxRate;

    private final Integer cooldownWindowMinutes;

    private SamplingRateBoost(BuilderImpl builder) {
        this.maxRate = builder.maxRate;
        this.cooldownWindowMinutes = builder.cooldownWindowMinutes;
    }

    /**
     * <p>
     * Defines max temporary sampling rate to apply when a boost is triggered. Calculated boost rate by X-Ray will be
     * less than or equal to this max rate.
     * </p>
     * 
     * @return Defines max temporary sampling rate to apply when a boost is triggered. Calculated boost rate by X-Ray
     *         will be less than or equal to this max rate.
     */
    public final Double maxRate() {
        return maxRate;
    }

    /**
     * <p>
     * Sets the time window (in minutes) in which only one sampling rate boost can be triggered. After a boost occurs,
     * no further boosts are allowed until the next window.
     * </p>
     * 
     * @return Sets the time window (in minutes) in which only one sampling rate boost can be triggered. After a boost
     *         occurs, no further boosts are allowed until the next window.
     */
    public final Integer cooldownWindowMinutes() {
        return cooldownWindowMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxRate());
        hashCode = 31 * hashCode + Objects.hashCode(cooldownWindowMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingRateBoost)) {
            return false;
        }
        SamplingRateBoost other = (SamplingRateBoost) obj;
        return Objects.equals(maxRate(), other.maxRate())
                && Objects.equals(cooldownWindowMinutes(), other.cooldownWindowMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SamplingRateBoost").add("MaxRate", maxRate())
                .add("CooldownWindowMinutes", cooldownWindowMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxRate":
            return Optional.ofNullable(clazz.cast(maxRate()));
        case "CooldownWindowMinutes":
            return Optional.ofNullable(clazz.cast(cooldownWindowMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxRate", MAX_RATE_FIELD);
        map.put("CooldownWindowMinutes", COOLDOWN_WINDOW_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamplingRateBoost, T> g) {
        return obj -> g.apply((SamplingRateBoost) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamplingRateBoost> {
        /**
         * <p>
         * Defines max temporary sampling rate to apply when a boost is triggered. Calculated boost rate by X-Ray will
         * be less than or equal to this max rate.
         * </p>
         * 
         * @param maxRate
         *        Defines max temporary sampling rate to apply when a boost is triggered. Calculated boost rate by X-Ray
         *        will be less than or equal to this max rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRate(Double maxRate);

        /**
         * <p>
         * Sets the time window (in minutes) in which only one sampling rate boost can be triggered. After a boost
         * occurs, no further boosts are allowed until the next window.
         * </p>
         * 
         * @param cooldownWindowMinutes
         *        Sets the time window (in minutes) in which only one sampling rate boost can be triggered. After a
         *        boost occurs, no further boosts are allowed until the next window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cooldownWindowMinutes(Integer cooldownWindowMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Double maxRate;

        private Integer cooldownWindowMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingRateBoost model) {
            maxRate(model.maxRate);
            cooldownWindowMinutes(model.cooldownWindowMinutes);
        }

        public final Double getMaxRate() {
            return maxRate;
        }

        public final void setMaxRate(Double maxRate) {
            this.maxRate = maxRate;
        }

        @Override
        public final Builder maxRate(Double maxRate) {
            this.maxRate = maxRate;
            return this;
        }

        public final Integer getCooldownWindowMinutes() {
            return cooldownWindowMinutes;
        }

        public final void setCooldownWindowMinutes(Integer cooldownWindowMinutes) {
            this.cooldownWindowMinutes = cooldownWindowMinutes;
        }

        @Override
        public final Builder cooldownWindowMinutes(Integer cooldownWindowMinutes) {
            this.cooldownWindowMinutes = cooldownWindowMinutes;
            return this;
        }

        @Override
        public SamplingRateBoost build() {
            return new SamplingRateBoost(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
