/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.Alias;
import software.amazon.awssdk.services.xray.model.AliasListCopier;
import software.amazon.awssdk.services.xray.model.EdgeStatistics;
import software.amazon.awssdk.services.xray.model.HistogramCopier;
import software.amazon.awssdk.services.xray.model.HistogramEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Edge
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Edge> {
    private static final SdkField<Integer> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReferenceId").getter(Edge.getter(Edge::referenceId)).setter(Edge.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Edge.getter(Edge::startTime)).setter(Edge.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(Edge.getter(Edge::endTime)).setter(Edge.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<EdgeStatistics> SUMMARY_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SummaryStatistics").getter(Edge.getter(Edge::summaryStatistics)).setter(Edge.setter(Builder::summaryStatistics)).constructor(EdgeStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryStatistics").build()}).build();
    private static final SdkField<List<HistogramEntry>> RESPONSE_TIME_HISTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResponseTimeHistogram").getter(Edge.getter(Edge::responseTimeHistogram)).setter(Edge.setter(Builder::responseTimeHistogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTimeHistogram").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HistogramEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Alias>> ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aliases").getter(Edge.getter(Edge::aliases)).setter(Edge.setter(Builder::aliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Alias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EDGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeType").getter(Edge.getter(Edge::edgeType)).setter(Edge.setter(Builder::edgeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeType").build()}).build();
    private static final SdkField<List<HistogramEntry>> RECEIVED_EVENT_AGE_HISTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReceivedEventAgeHistogram").getter(Edge.getter(Edge::receivedEventAgeHistogram)).setter(Edge.setter(Builder::receivedEventAgeHistogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedEventAgeHistogram").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HistogramEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, SUMMARY_STATISTICS_FIELD, RESPONSE_TIME_HISTOGRAM_FIELD, ALIASES_FIELD, EDGE_TYPE_FIELD, RECEIVED_EVENT_AGE_HISTOGRAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Edge.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer referenceId;
    private final Instant startTime;
    private final Instant endTime;
    private final EdgeStatistics summaryStatistics;
    private final List<HistogramEntry> responseTimeHistogram;
    private final List<Alias> aliases;
    private final String edgeType;
    private final List<HistogramEntry> receivedEventAgeHistogram;

    private Edge(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.summaryStatistics = builder.summaryStatistics;
        this.responseTimeHistogram = builder.responseTimeHistogram;
        this.aliases = builder.aliases;
        this.edgeType = builder.edgeType;
        this.receivedEventAgeHistogram = builder.receivedEventAgeHistogram;
    }

    public final Integer referenceId() {
        return this.referenceId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final EdgeStatistics summaryStatistics() {
        return this.summaryStatistics;
    }

    public final boolean hasResponseTimeHistogram() {
        return this.responseTimeHistogram != null && !(this.responseTimeHistogram instanceof SdkAutoConstructList);
    }

    public final List<HistogramEntry> responseTimeHistogram() {
        return this.responseTimeHistogram;
    }

    public final boolean hasAliases() {
        return this.aliases != null && !(this.aliases instanceof SdkAutoConstructList);
    }

    public final List<Alias> aliases() {
        return this.aliases;
    }

    public final String edgeType() {
        return this.edgeType;
    }

    public final boolean hasReceivedEventAgeHistogram() {
        return this.receivedEventAgeHistogram != null && !(this.receivedEventAgeHistogram instanceof SdkAutoConstructList);
    }

    public final List<HistogramEntry> receivedEventAgeHistogram() {
        return this.receivedEventAgeHistogram;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.summaryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseTimeHistogram() ? this.responseTimeHistogram() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliases() ? this.aliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReceivedEventAgeHistogram() ? this.receivedEventAgeHistogram() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)obj;
        return Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.summaryStatistics(), other.summaryStatistics()) && this.hasResponseTimeHistogram() == other.hasResponseTimeHistogram() && Objects.equals(this.responseTimeHistogram(), other.responseTimeHistogram()) && this.hasAliases() == other.hasAliases() && Objects.equals(this.aliases(), other.aliases()) && Objects.equals(this.edgeType(), other.edgeType()) && this.hasReceivedEventAgeHistogram() == other.hasReceivedEventAgeHistogram() && Objects.equals(this.receivedEventAgeHistogram(), other.receivedEventAgeHistogram());
    }

    public final String toString() {
        return ToString.builder((String)"Edge").add("ReferenceId", (Object)this.referenceId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("SummaryStatistics", (Object)this.summaryStatistics()).add("ResponseTimeHistogram", this.hasResponseTimeHistogram() ? this.responseTimeHistogram() : null).add("Aliases", this.hasAliases() ? this.aliases() : null).add("EdgeType", (Object)this.edgeType()).add("ReceivedEventAgeHistogram", this.hasReceivedEventAgeHistogram() ? this.receivedEventAgeHistogram() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "SummaryStatistics": {
                return Optional.ofNullable(clazz.cast(this.summaryStatistics()));
            }
            case "ResponseTimeHistogram": {
                return Optional.ofNullable(clazz.cast(this.responseTimeHistogram()));
            }
            case "Aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
            case "EdgeType": {
                return Optional.ofNullable(clazz.cast(this.edgeType()));
            }
            case "ReceivedEventAgeHistogram": {
                return Optional.ofNullable(clazz.cast(this.receivedEventAgeHistogram()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReferenceId", REFERENCE_ID_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("SummaryStatistics", SUMMARY_STATISTICS_FIELD);
        map.put("ResponseTimeHistogram", RESPONSE_TIME_HISTOGRAM_FIELD);
        map.put("Aliases", ALIASES_FIELD);
        map.put("EdgeType", EDGE_TYPE_FIELD);
        map.put("ReceivedEventAgeHistogram", RECEIVED_EVENT_AGE_HISTOGRAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Edge, T> g) {
        return obj -> g.apply((Edge)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer referenceId;
        private Instant startTime;
        private Instant endTime;
        private EdgeStatistics summaryStatistics;
        private List<HistogramEntry> responseTimeHistogram = DefaultSdkAutoConstructList.getInstance();
        private List<Alias> aliases = DefaultSdkAutoConstructList.getInstance();
        private String edgeType;
        private List<HistogramEntry> receivedEventAgeHistogram = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Edge model) {
            this.referenceId(model.referenceId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.summaryStatistics(model.summaryStatistics);
            this.responseTimeHistogram(model.responseTimeHistogram);
            this.aliases(model.aliases);
            this.edgeType(model.edgeType);
            this.receivedEventAgeHistogram(model.receivedEventAgeHistogram);
        }

        public final Integer getReferenceId() {
            return this.referenceId;
        }

        public final void setReferenceId(Integer referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(Integer referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final EdgeStatistics.Builder getSummaryStatistics() {
            return this.summaryStatistics != null ? this.summaryStatistics.toBuilder() : null;
        }

        public final void setSummaryStatistics(EdgeStatistics.BuilderImpl summaryStatistics) {
            this.summaryStatistics = summaryStatistics != null ? summaryStatistics.build() : null;
        }

        @Override
        public final Builder summaryStatistics(EdgeStatistics summaryStatistics) {
            this.summaryStatistics = summaryStatistics;
            return this;
        }

        public final List<HistogramEntry.Builder> getResponseTimeHistogram() {
            List<HistogramEntry.Builder> result = HistogramCopier.copyToBuilder(this.responseTimeHistogram);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponseTimeHistogram(Collection<HistogramEntry.BuilderImpl> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copyFromBuilder(responseTimeHistogram);
        }

        @Override
        public final Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copy(responseTimeHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(HistogramEntry ... responseTimeHistogram) {
            this.responseTimeHistogram(Arrays.asList(responseTimeHistogram));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(Consumer<HistogramEntry.Builder> ... responseTimeHistogram) {
            this.responseTimeHistogram(Stream.of(responseTimeHistogram).map(c -> (HistogramEntry)((HistogramEntry.Builder)HistogramEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Alias.Builder> getAliases() {
            List<Alias.Builder> result = AliasListCopier.copyToBuilder(this.aliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAliases(Collection<Alias.BuilderImpl> aliases) {
            this.aliases = AliasListCopier.copyFromBuilder(aliases);
        }

        @Override
        public final Builder aliases(Collection<Alias> aliases) {
            this.aliases = AliasListCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Alias ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Consumer<Alias.Builder> ... aliases) {
            this.aliases(Stream.of(aliases).map(c -> (Alias)((Alias.Builder)Alias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEdgeType() {
            return this.edgeType;
        }

        public final void setEdgeType(String edgeType) {
            this.edgeType = edgeType;
        }

        @Override
        public final Builder edgeType(String edgeType) {
            this.edgeType = edgeType;
            return this;
        }

        public final List<HistogramEntry.Builder> getReceivedEventAgeHistogram() {
            List<HistogramEntry.Builder> result = HistogramCopier.copyToBuilder(this.receivedEventAgeHistogram);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReceivedEventAgeHistogram(Collection<HistogramEntry.BuilderImpl> receivedEventAgeHistogram) {
            this.receivedEventAgeHistogram = HistogramCopier.copyFromBuilder(receivedEventAgeHistogram);
        }

        @Override
        public final Builder receivedEventAgeHistogram(Collection<HistogramEntry> receivedEventAgeHistogram) {
            this.receivedEventAgeHistogram = HistogramCopier.copy(receivedEventAgeHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receivedEventAgeHistogram(HistogramEntry ... receivedEventAgeHistogram) {
            this.receivedEventAgeHistogram(Arrays.asList(receivedEventAgeHistogram));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receivedEventAgeHistogram(Consumer<HistogramEntry.Builder> ... receivedEventAgeHistogram) {
            this.receivedEventAgeHistogram(Stream.of(receivedEventAgeHistogram).map(c -> (HistogramEntry)((HistogramEntry.Builder)HistogramEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Edge build() {
            return new Edge(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Edge> {
        public Builder referenceId(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder summaryStatistics(EdgeStatistics var1);

        default public Builder summaryStatistics(Consumer<EdgeStatistics.Builder> summaryStatistics) {
            return this.summaryStatistics((EdgeStatistics)((EdgeStatistics.Builder)EdgeStatistics.builder().applyMutation(summaryStatistics)).build());
        }

        public Builder responseTimeHistogram(Collection<HistogramEntry> var1);

        public Builder responseTimeHistogram(HistogramEntry ... var1);

        public Builder responseTimeHistogram(Consumer<HistogramEntry.Builder> ... var1);

        public Builder aliases(Collection<Alias> var1);

        public Builder aliases(Alias ... var1);

        public Builder aliases(Consumer<Alias.Builder> ... var1);

        public Builder edgeType(String var1);

        public Builder receivedEventAgeHistogram(Collection<HistogramEntry> var1);

        public Builder receivedEventAgeHistogram(HistogramEntry ... var1);

        public Builder receivedEventAgeHistogram(Consumer<HistogramEntry.Builder> ... var1);
    }
}

