/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.environment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.config.Configuration;
import software.amazon.cloudwatchlogs.emf.config.SystemWrapper;
import software.amazon.cloudwatchlogs.emf.environment.AgentBasedEnvironment;
import software.amazon.cloudwatchlogs.emf.environment.ResourceFetcher;
import software.amazon.cloudwatchlogs.emf.model.MetricsContext;
import software.amazon.cloudwatchlogs.emf.util.StringUtils;

class ECSEnvironment
extends AgentBasedEnvironment {
    private static final Logger log = LoggerFactory.getLogger(ECSEnvironment.class);
    private Configuration config;
    private ECSMetadata metadata;
    private ResourceFetcher fetcher;
    private String fluentBitEndpoint;
    private String hostname;
    private static final String ECS_CONTAINER_METADATA_URI = "ECS_CONTAINER_METADATA_URI";
    private static final String FLUENT_HOST = "FLUENT_HOST";
    private static final String ENVIRONMENT_TYPE = "AWS::ECS::Container";

    ECSEnvironment(Configuration config, ResourceFetcher fetcher) {
        super(config);
        this.config = config;
        this.fetcher = fetcher;
    }

    @Override
    public boolean probe() {
        String uri = this.getEnv(ECS_CONTAINER_METADATA_URI);
        if (uri == null) {
            return false;
        }
        this.checkAndSetFluentHost();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        URI parsedURI = null;
        try {
            parsedURI = new URI(uri);
            this.metadata = this.fetcher.fetch(parsedURI, objectMapper, ECSMetadata.class);
            this.formatImageName();
            return true;
        }
        catch (Exception ex) {
            log.debug("Failed to get response from: " + parsedURI, (Throwable)ex);
            return false;
        }
    }

    @Override
    public String getName() {
        if (this.config.getServiceName().isPresent()) {
            return this.config.getServiceName().get();
        }
        if (this.metadata != null && !StringUtils.isNullOrEmpty(this.metadata.formattedImageName)) {
            return this.metadata.formattedImageName;
        }
        return "Unknown";
    }

    @Override
    public String getType() {
        if (this.config.getServiceType().isPresent()) {
            return this.config.getServiceType().get();
        }
        return ENVIRONMENT_TYPE;
    }

    @Override
    public String getLogGroupName() {
        if (this.fluentBitEndpoint != null) {
            return "";
        }
        return super.getLogGroupName();
    }

    @Override
    public void configureContext(MetricsContext context) {
        context.putProperty("containerId", this.getHostName());
        context.putProperty("createdAt", this.metadata.createdAt);
        context.putProperty("startedAt", this.metadata.startedAt);
        context.putProperty("image", this.metadata.image);
        context.putProperty("cluster", this.metadata.labels.get("com.amazonaws.ecs.cluster"));
        context.putProperty("taskArn", this.metadata.labels.get("com.amazonaws.ecs.task-arn"));
    }

    private String getHostName() {
        if (this.hostname != null) {
            return this.hostname;
        }
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            log.debug("Unable to get hostname: ", (Throwable)ex);
        }
        return this.hostname;
    }

    private String getEnv(String name) {
        return SystemWrapper.getenv(name);
    }

    private void checkAndSetFluentHost() {
        String fluentHost = this.getEnv(FLUENT_HOST);
        if (fluentHost != null && !this.config.getAgentEndpoint().isPresent()) {
            this.fluentBitEndpoint = String.format("tcp://%s:%d", fluentHost, 25888);
            this.config.setAgentEndpoint(this.fluentBitEndpoint);
            log.info("Using FluentBit configuration. Endpoint: {}", (Object)this.fluentBitEndpoint);
        }
    }

    private void formatImageName() {
        if (this.metadata != null && this.metadata.image != null) {
            String imageName = this.metadata.image;
            String[] splitImageNames = imageName.split("\\/");
            this.metadata.formattedImageName = splitImageNames[splitImageNames.length - 1];
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class ECSMetadata {
        String name;
        String dockerId;
        String dockerName;
        String image;
        String formattedImageName;
        String imageID;
        Map<String, String> labels;
        String createdAt;
        String startedAt;

        public String getName() {
            return this.name;
        }

        public String getDockerId() {
            return this.dockerId;
        }

        public String getDockerName() {
            return this.dockerName;
        }

        public String getImage() {
            return this.image;
        }

        public String getFormattedImageName() {
            return this.formattedImageName;
        }

        public String getImageID() {
            return this.imageID;
        }

        public Map<String, String> getLabels() {
            return this.labels;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public String getStartedAt() {
            return this.startedAt;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDockerId(String dockerId) {
            this.dockerId = dockerId;
        }

        public void setDockerName(String dockerName) {
            this.dockerName = dockerName;
        }

        public void setImage(String image) {
            this.image = image;
        }

        public void setFormattedImageName(String formattedImageName) {
            this.formattedImageName = formattedImageName;
        }

        public void setImageID(String imageID) {
            this.imageID = imageID;
        }

        public void setLabels(Map<String, String> labels) {
            this.labels = labels;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public void setStartedAt(String startedAt) {
            this.startedAt = startedAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ECSMetadata)) {
                return false;
            }
            ECSMetadata other = (ECSMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$dockerId = this.getDockerId();
            String other$dockerId = other.getDockerId();
            if (this$dockerId == null ? other$dockerId != null : !this$dockerId.equals(other$dockerId)) {
                return false;
            }
            String this$dockerName = this.getDockerName();
            String other$dockerName = other.getDockerName();
            if (this$dockerName == null ? other$dockerName != null : !this$dockerName.equals(other$dockerName)) {
                return false;
            }
            String this$image = this.getImage();
            String other$image = other.getImage();
            if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
                return false;
            }
            String this$formattedImageName = this.getFormattedImageName();
            String other$formattedImageName = other.getFormattedImageName();
            if (this$formattedImageName == null ? other$formattedImageName != null : !this$formattedImageName.equals(other$formattedImageName)) {
                return false;
            }
            String this$imageID = this.getImageID();
            String other$imageID = other.getImageID();
            if (this$imageID == null ? other$imageID != null : !this$imageID.equals(other$imageID)) {
                return false;
            }
            Map<String, String> this$labels = this.getLabels();
            Map<String, String> other$labels = other.getLabels();
            if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
                return false;
            }
            String this$createdAt = this.getCreatedAt();
            String other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
                return false;
            }
            String this$startedAt = this.getStartedAt();
            String other$startedAt = other.getStartedAt();
            return !(this$startedAt == null ? other$startedAt != null : !this$startedAt.equals(other$startedAt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ECSMetadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $dockerId = this.getDockerId();
            result = result * 59 + ($dockerId == null ? 43 : $dockerId.hashCode());
            String $dockerName = this.getDockerName();
            result = result * 59 + ($dockerName == null ? 43 : $dockerName.hashCode());
            String $image = this.getImage();
            result = result * 59 + ($image == null ? 43 : $image.hashCode());
            String $formattedImageName = this.getFormattedImageName();
            result = result * 59 + ($formattedImageName == null ? 43 : $formattedImageName.hashCode());
            String $imageID = this.getImageID();
            result = result * 59 + ($imageID == null ? 43 : $imageID.hashCode());
            Map<String, String> $labels = this.getLabels();
            result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
            String $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
            String $startedAt = this.getStartedAt();
            result = result * 59 + ($startedAt == null ? 43 : $startedAt.hashCode());
            return result;
        }

        public String toString() {
            return "ECSEnvironment.ECSMetadata(name=" + this.getName() + ", dockerId=" + this.getDockerId() + ", dockerName=" + this.getDockerName() + ", image=" + this.getImage() + ", formattedImageName=" + this.getFormattedImageName() + ", imageID=" + this.getImageID() + ", labels=" + this.getLabels() + ", createdAt=" + this.getCreatedAt() + ", startedAt=" + this.getStartedAt() + ")";
        }
    }
}

