/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.cloudwatchlogs.emf.exception.DimensionSetExceededException;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.EmptyMetricsFilter;
import software.amazon.cloudwatchlogs.emf.model.Metadata;
import software.amazon.cloudwatchlogs.emf.model.MetricDefinition;
import software.amazon.cloudwatchlogs.emf.model.MetricDirective;

@JsonFilter(value="emptyMetricFilter")
class RootNode {
    @JsonProperty(value="_aws")
    private final Metadata aws;
    private Map<String, Object> properties;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("emptyMetricFilter", (SimpleBeanPropertyFilter)new EmptyMetricsFilter());

    RootNode() {
        this.aws = new Metadata();
        this.properties = new ConcurrentHashMap<String, Object>();
        objectMapper.setFilterProvider((FilterProvider)filterProvider);
    }

    public void putProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonAnyGetter
    Map<String, Object> getTargetMembers() throws DimensionSetExceededException {
        HashMap<String, Object> targetMembers = new HashMap<String, Object>();
        targetMembers.putAll(this.properties);
        targetMembers.putAll(this.getDimensions());
        for (MetricDirective metricDirective : this.aws.getCloudWatchMetrics()) {
            for (MetricDefinition metric : metricDirective.getMetrics().values()) {
                List<Double> values = metric.getValues();
                targetMembers.put(metric.getName(), values.size() == 1 ? values.get(0) : values);
            }
        }
        return targetMembers;
    }

    Map<String, String> getDimensions() throws DimensionSetExceededException {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        for (MetricDirective mc : this.aws.getCloudWatchMetrics()) {
            for (DimensionSet dimensionSet : mc.getAllDimensions()) {
                dimensions.putAll(dimensionSet.getDimensionRecords());
            }
        }
        return dimensions;
    }

    Map<String, MetricDefinition> metrics() {
        return this.aws.getCloudWatchMetrics().get(0).getMetrics();
    }

    String serialize() throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)this);
    }

    public RootNode(Metadata aws, Map<String, Object> properties) {
        this.aws = aws;
        this.properties = properties;
    }

    public Metadata getAws() {
        return this.aws;
    }

    public RootNode withAws(Metadata aws) {
        return this.aws == aws ? this : new RootNode(aws, this.properties);
    }
}

