/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.com.amazon.ion.impl.lite;

import codegurushadow.com.amazon.ion.IonBool;
import codegurushadow.com.amazon.ion.IonType;
import codegurushadow.com.amazon.ion.IonWriter;
import codegurushadow.com.amazon.ion.NullValueException;
import codegurushadow.com.amazon.ion.ValueVisitor;
import codegurushadow.com.amazon.ion.impl._Private_IonValue;
import codegurushadow.com.amazon.ion.impl.lite.ContainerlessContext;
import codegurushadow.com.amazon.ion.impl.lite.IonContext;
import codegurushadow.com.amazon.ion.impl.lite.IonValueLite;
import java.io.IOException;

final class IonBoolLite
extends IonValueLite
implements IonBool {
    private static final int HASH_SIGNATURE = IonType.BOOL.toString().hashCode();
    protected static final int TRUE_HASH = HASH_SIGNATURE ^ 16777619 * Boolean.TRUE.hashCode();
    protected static final int FALSE_HASH = HASH_SIGNATURE ^ 16777619 * Boolean.FALSE.hashCode();

    IonBoolLite(ContainerlessContext context, boolean isNull) {
        super(context, isNull);
    }

    IonBoolLite(IonBoolLite existing, IonContext context) {
        super(existing, context);
    }

    @Override
    IonBoolLite clone(IonContext context) {
        return new IonBoolLite(this, context);
    }

    @Override
    public IonBoolLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    public IonType getType() {
        return IonType.BOOL;
    }

    @Override
    int hashCode(_Private_IonValue.SymbolTableProvider symbolTableProvider) {
        int result = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            result = this.booleanValue() ? TRUE_HASH : FALSE_HASH;
        }
        return this.hashTypeAnnotations(result, symbolTableProvider);
    }

    @Override
    public boolean booleanValue() throws NullValueException {
        this.validateThisNotNull();
        return this._isBoolTrue();
    }

    @Override
    public void setValue(boolean b) {
        this.setValue((Boolean)b);
    }

    @Override
    public void setValue(Boolean b) {
        this.checkForLock();
        if (b == null) {
            this._isBoolTrue(false);
            this._isNullValue(true);
        } else {
            this._isBoolTrue(b);
            this._isNullValue(false);
        }
    }

    @Override
    final void writeBodyTo(IonWriter writer, _Private_IonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        if (this.isNullValue()) {
            writer.writeNull(IonType.BOOL);
        } else {
            writer.writeBool(this._isBoolTrue());
        }
    }

    @Override
    public void accept(ValueVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

