/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.com.amazon.ion.impl.lite;

import codegurushadow.com.amazon.ion.IonCatalog;
import codegurushadow.com.amazon.ion.IonDatagram;
import codegurushadow.com.amazon.ion.IonException;
import codegurushadow.com.amazon.ion.IonLoader;
import codegurushadow.com.amazon.ion.IonReader;
import codegurushadow.com.amazon.ion.IonSystem;
import codegurushadow.com.amazon.ion.IonTextReader;
import codegurushadow.com.amazon.ion.IonWriter;
import codegurushadow.com.amazon.ion.impl._Private_IncrementalReader;
import codegurushadow.com.amazon.ion.impl._Private_IonWriterFactory;
import codegurushadow.com.amazon.ion.impl.lite.IonDatagramLite;
import codegurushadow.com.amazon.ion.impl.lite.IonSystemLite;
import codegurushadow.com.amazon.ion.system.IonReaderBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

final class IonLoaderLite
implements IonLoader {
    private final IonSystemLite _system;
    private final IonCatalog _catalog;
    private final IonReaderBuilder _readerBuilder;

    public IonLoaderLite(IonSystemLite system, IonCatalog catalog) {
        assert (system != null);
        assert (catalog != null);
        this._system = system;
        this._catalog = catalog;
        this._readerBuilder = catalog == system.getCatalog() ? system.getReaderBuilder() : system.getReaderBuilder().withCatalog(catalog).immutable();
    }

    @Override
    public IonSystem getSystem() {
        return this._system;
    }

    @Override
    public IonCatalog getCatalog() {
        return this._catalog;
    }

    private IonDatagramLite load_helper(IonReader reader) throws IOException {
        IonDatagramLite datagram = new IonDatagramLite(this._system, this._catalog);
        IonWriter writer = _Private_IonWriterFactory.makeWriter(datagram);
        writer.writeValues(reader);
        return datagram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IonDatagram load(File ionFile) throws IonException, IOException {
        FileInputStream ionData = new FileInputStream(ionFile);
        try {
            IonDatagram datagram;
            IonDatagram ionDatagram = datagram = this.load(ionData);
            return ionDatagram;
        }
        finally {
            ((InputStream)ionData).close();
        }
    }

    @Override
    public IonDatagram load(String ionText) throws IonException {
        try {
            IonTextReader reader = this._readerBuilder.build(ionText);
            IonDatagramLite datagram = this.load_helper(reader);
            return datagram;
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }

    @Override
    public IonDatagram load(Reader ionText) throws IonException, IOException {
        try {
            IonReader reader = this._readerBuilder.build(ionText);
            IonDatagramLite datagram = this.load_helper(reader);
            return datagram;
        }
        catch (IonException e) {
            IOException io = e.causeOfType(IOException.class);
            if (io != null) {
                throw io;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IonDatagram load(byte[] ionData) throws IonException {
        IonReader reader = this._readerBuilder.build(ionData, 0, ionData.length);
        try {
            IonDatagram ionDatagram = this.load(reader);
            return ionDatagram;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new IonException(e);
            }
        }
    }

    @Override
    public IonDatagram load(InputStream ionData) throws IonException, IOException {
        IonReader reader = null;
        try {
            reader = this._readerBuilder.build(ionData);
            IonDatagram ionDatagram = this.load(reader);
            return ionDatagram;
        }
        catch (IonException e) {
            IOException io = e.causeOfType(IOException.class);
            if (io != null) {
                throw io;
            }
            throw e;
        }
        finally {
            if (this._readerBuilder.isIncrementalReadingEnabled() && reader instanceof _Private_IncrementalReader) {
                ((_Private_IncrementalReader)((Object)reader)).requireCompleteValue();
            }
        }
    }

    @Override
    public IonDatagram load(IonReader reader) throws IonException {
        try {
            IonDatagramLite datagram = this.load_helper(reader);
            return datagram;
        }
        catch (IOException e) {
            throw new IonException(e);
        }
    }
}

