/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.com.amazon.ion.system;

import codegurushadow.com.amazon.ion.IonBufferConfiguration;
import codegurushadow.com.amazon.ion.IonCatalog;
import codegurushadow.com.amazon.ion.IonReader;
import codegurushadow.com.amazon.ion.IonTextReader;
import codegurushadow.com.amazon.ion.IonValue;
import codegurushadow.com.amazon.ion.impl._Private_IonReaderBuilder;
import codegurushadow.com.amazon.ion.system.SimpleCatalog;
import java.io.InputStream;
import java.io.Reader;

public abstract class IonReaderBuilder {
    private IonCatalog catalog = null;
    private boolean isIncrementalReadingEnabled = false;
    private IonBufferConfiguration bufferConfiguration = null;
    private boolean isAnnotationIteratorReuseEnabled = true;

    protected IonReaderBuilder() {
    }

    protected IonReaderBuilder(IonReaderBuilder that) {
        this.catalog = that.catalog;
        this.isIncrementalReadingEnabled = that.isIncrementalReadingEnabled;
        this.bufferConfiguration = that.bufferConfiguration;
        this.isAnnotationIteratorReuseEnabled = that.isAnnotationIteratorReuseEnabled;
    }

    public static IonReaderBuilder standard() {
        return new _Private_IonReaderBuilder.Mutable();
    }

    public IonReaderBuilder copy() {
        return new _Private_IonReaderBuilder.Mutable(this);
    }

    public IonReaderBuilder immutable() {
        return this;
    }

    public IonReaderBuilder mutable() {
        return this.copy();
    }

    protected void mutationCheck() {
        throw new UnsupportedOperationException("This builder is immutable");
    }

    public IonReaderBuilder withCatalog(IonCatalog catalog) {
        IonReaderBuilder b = this.mutable();
        b.setCatalog(catalog);
        return b;
    }

    public void setCatalog(IonCatalog catalog) {
        this.mutationCheck();
        this.catalog = catalog;
    }

    public IonCatalog getCatalog() {
        return this.catalog;
    }

    protected IonCatalog validateCatalog() {
        return this.catalog != null ? this.catalog : new SimpleCatalog();
    }

    public IonReaderBuilder withIncrementalReadingEnabled(boolean isEnabled) {
        IonReaderBuilder b = this.mutable();
        if (isEnabled) {
            b.setIncrementalReadingEnabled();
        } else {
            b.setIncrementalReadingDisabled();
        }
        return b;
    }

    public void setIncrementalReadingEnabled() {
        this.mutationCheck();
        this.isIncrementalReadingEnabled = true;
    }

    public void setIncrementalReadingDisabled() {
        this.mutationCheck();
        this.isIncrementalReadingEnabled = false;
    }

    public boolean isIncrementalReadingEnabled() {
        return this.isIncrementalReadingEnabled;
    }

    public IonReaderBuilder withBufferConfiguration(IonBufferConfiguration configuration) {
        IonReaderBuilder b = this.mutable();
        b.setBufferConfiguration(configuration);
        return b;
    }

    public void setBufferConfiguration(IonBufferConfiguration configuration) {
        this.mutationCheck();
        this.bufferConfiguration = configuration;
    }

    public IonBufferConfiguration getBufferConfiguration() {
        return this.bufferConfiguration;
    }

    public IonReaderBuilder withAnnotationIteratorReuseEnabled(boolean isEnabled) {
        IonReaderBuilder b = this.mutable();
        if (isEnabled) {
            b.setAnnotationIteratorReuseEnabled();
        } else {
            b.setAnnotationIteratorReuseDisabled();
        }
        return b;
    }

    public void setAnnotationIteratorReuseEnabled() {
        this.mutationCheck();
        this.isAnnotationIteratorReuseEnabled = true;
    }

    public void setAnnotationIteratorReuseDisabled() {
        this.mutationCheck();
        this.isAnnotationIteratorReuseEnabled = false;
    }

    public boolean isAnnotationIteratorReuseEnabled() {
        return this.isAnnotationIteratorReuseEnabled;
    }

    public IonReader build(byte[] ionData) {
        return this.build(ionData, 0, ionData.length);
    }

    public abstract IonReader build(byte[] var1, int var2, int var3);

    public abstract IonReader build(InputStream var1);

    public abstract IonReader build(Reader var1);

    public abstract IonReader build(IonValue var1);

    public abstract IonTextReader build(String var1);
}

