/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.com.fasterxml.jackson.databind.ser.std;

import codegurushadow.com.fasterxml.jackson.core.JsonGenerator;
import codegurushadow.com.fasterxml.jackson.databind.JavaType;
import codegurushadow.com.fasterxml.jackson.databind.JsonMappingException;
import codegurushadow.com.fasterxml.jackson.databind.SerializerProvider;
import codegurushadow.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import codegurushadow.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import codegurushadow.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import codegurushadow.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import codegurushadow.com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

