/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.io.netty.handler.codec.dns;

import codegurushadow.io.netty.buffer.ByteBuf;
import codegurushadow.io.netty.channel.AddressedEnvelope;
import codegurushadow.io.netty.channel.ChannelHandler;
import codegurushadow.io.netty.channel.ChannelHandlerContext;
import codegurushadow.io.netty.channel.socket.DatagramPacket;
import codegurushadow.io.netty.handler.codec.MessageToMessageEncoder;
import codegurushadow.io.netty.handler.codec.dns.DnsQuery;
import codegurushadow.io.netty.handler.codec.dns.DnsQueryEncoder;
import codegurushadow.io.netty.handler.codec.dns.DnsRecordEncoder;
import java.net.InetSocketAddress;
import java.util.List;

@ChannelHandler.Sharable
public class DatagramDnsQueryEncoder
extends MessageToMessageEncoder<AddressedEnvelope<DnsQuery, InetSocketAddress>> {
    private final DnsQueryEncoder encoder;

    public DatagramDnsQueryEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public DatagramDnsQueryEncoder(DnsRecordEncoder recordEncoder) {
        this.encoder = new DnsQueryEncoder(recordEncoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<DnsQuery, InetSocketAddress> in, List<Object> out) throws Exception {
        InetSocketAddress recipient = in.recipient();
        DnsQuery query = in.content();
        ByteBuf buf = this.allocateBuffer(ctx, in);
        boolean success = false;
        try {
            this.encoder.encode(query, buf);
            success = true;
        }
        finally {
            if (!success) {
                buf.release();
            }
        }
        out.add(new DatagramPacket(buf, recipient, null));
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, AddressedEnvelope<DnsQuery, InetSocketAddress> msg) throws Exception {
        return ctx.alloc().ioBuffer(1024);
    }
}

