/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.io.netty.handler.codec.dns;

import codegurushadow.io.netty.handler.codec.dns.AbstractDnsRecord;
import codegurushadow.io.netty.handler.codec.dns.DnsMessageUtil;
import codegurushadow.io.netty.handler.codec.dns.DnsPtrRecord;
import codegurushadow.io.netty.handler.codec.dns.DnsRecordType;
import codegurushadow.io.netty.util.internal.ObjectUtil;
import codegurushadow.io.netty.util.internal.StringUtil;

public class DefaultDnsPtrRecord
extends AbstractDnsRecord
implements DnsPtrRecord {
    private final String hostname;

    public DefaultDnsPtrRecord(String name, int dnsClass, long timeToLive, String hostname) {
        super(name, DnsRecordType.PTR, dnsClass, timeToLive);
        this.hostname = ObjectUtil.checkNotNull(hostname, "hostname");
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64).append(StringUtil.simpleClassName(this)).append('(');
        DnsRecordType type = this.type();
        buf.append(this.name().isEmpty() ? "<root>" : this.name()).append(' ').append(this.timeToLive()).append(' ');
        DnsMessageUtil.appendRecordClass(buf, this.dnsClass()).append(' ').append(type.name());
        buf.append(' ').append(this.hostname);
        return buf.toString();
    }
}

