/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.io.netty.handler.codec.dns;

import codegurushadow.io.netty.buffer.ByteBuf;
import codegurushadow.io.netty.channel.ChannelHandler;
import codegurushadow.io.netty.channel.ChannelHandlerContext;
import codegurushadow.io.netty.handler.codec.MessageToByteEncoder;
import codegurushadow.io.netty.handler.codec.dns.DnsQuery;
import codegurushadow.io.netty.handler.codec.dns.DnsQueryEncoder;
import codegurushadow.io.netty.handler.codec.dns.DnsRecordEncoder;

@ChannelHandler.Sharable
public final class TcpDnsQueryEncoder
extends MessageToByteEncoder<DnsQuery> {
    private final DnsQueryEncoder encoder;

    public TcpDnsQueryEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public TcpDnsQueryEncoder(DnsRecordEncoder recordEncoder) {
        this.encoder = new DnsQueryEncoder(recordEncoder);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, DnsQuery msg, ByteBuf out) throws Exception {
        out.writerIndex(out.writerIndex() + 2);
        this.encoder.encode(msg, out);
        out.setShort(0, out.readableBytes() - 2);
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, DnsQuery msg, boolean preferDirect) {
        if (preferDirect) {
            return ctx.alloc().ioBuffer(1024);
        }
        return ctx.alloc().heapBuffer(1024);
    }
}

