/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.io.netty.handler.codec.socksx.v4;

import codegurushadow.io.netty.buffer.ByteBuf;
import codegurushadow.io.netty.buffer.ByteBufUtil;
import codegurushadow.io.netty.channel.ChannelHandler;
import codegurushadow.io.netty.channel.ChannelHandlerContext;
import codegurushadow.io.netty.handler.codec.MessageToByteEncoder;
import codegurushadow.io.netty.handler.codec.socksx.v4.Socks4CommandRequest;
import codegurushadow.io.netty.util.NetUtil;

@ChannelHandler.Sharable
public final class Socks4ClientEncoder
extends MessageToByteEncoder<Socks4CommandRequest> {
    public static final Socks4ClientEncoder INSTANCE = new Socks4ClientEncoder();
    private static final byte[] IPv4_DOMAIN_MARKER = new byte[]{0, 0, 0, 1};

    private Socks4ClientEncoder() {
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Socks4CommandRequest msg, ByteBuf out) throws Exception {
        out.writeByte(msg.version().byteValue());
        out.writeByte(msg.type().byteValue());
        out.writeShort(msg.dstPort());
        if (NetUtil.isValidIpV4Address(msg.dstAddr())) {
            out.writeBytes(NetUtil.createByteArrayFromIpAddressString(msg.dstAddr()));
            ByteBufUtil.writeAscii(out, (CharSequence)msg.userId());
            out.writeByte(0);
        } else {
            out.writeBytes(IPv4_DOMAIN_MARKER);
            ByteBufUtil.writeAscii(out, (CharSequence)msg.userId());
            out.writeByte(0);
            ByteBufUtil.writeAscii(out, (CharSequence)msg.dstAddr());
            out.writeByte(0);
        }
    }
}

