/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.kotlin.jvm.internal;

import codegurushadow.kotlin.SinceKotlin;
import codegurushadow.kotlin.collections.ArraysKt;
import codegurushadow.kotlin.jvm.internal.FunctionBase;
import codegurushadow.kotlin.jvm.internal.FunctionReference;
import codegurushadow.kotlin.jvm.internal.Lambda;
import codegurushadow.kotlin.jvm.internal.MutablePropertyReference0;
import codegurushadow.kotlin.jvm.internal.MutablePropertyReference1;
import codegurushadow.kotlin.jvm.internal.MutablePropertyReference2;
import codegurushadow.kotlin.jvm.internal.PropertyReference0;
import codegurushadow.kotlin.jvm.internal.PropertyReference1;
import codegurushadow.kotlin.jvm.internal.PropertyReference2;
import codegurushadow.kotlin.jvm.internal.ReflectionFactory;
import codegurushadow.kotlin.reflect.KClass;
import codegurushadow.kotlin.reflect.KDeclarationContainer;
import codegurushadow.kotlin.reflect.KFunction;
import codegurushadow.kotlin.reflect.KMutableProperty0;
import codegurushadow.kotlin.reflect.KMutableProperty1;
import codegurushadow.kotlin.reflect.KMutableProperty2;
import codegurushadow.kotlin.reflect.KProperty0;
import codegurushadow.kotlin.reflect.KProperty1;
import codegurushadow.kotlin.reflect.KProperty2;
import codegurushadow.kotlin.reflect.KType;
import codegurushadow.kotlin.reflect.KTypeProjection;
import java.util.Arrays;
import java.util.Collections;

public class Reflection {
    private static final ReflectionFactory factory;
    static final String REFLECTION_NOT_AVAILABLE = " (Kotlin reflection is not available)";
    private static final KClass[] EMPTY_K_CLASS_ARRAY;

    public static KClass createKotlinClass(Class javaClass) {
        return factory.createKotlinClass(javaClass);
    }

    public static KClass createKotlinClass(Class javaClass, String internalName) {
        return factory.createKotlinClass(javaClass, internalName);
    }

    public static KDeclarationContainer getOrCreateKotlinPackage(Class javaClass, String moduleName) {
        return factory.getOrCreateKotlinPackage(javaClass, moduleName);
    }

    public static KClass getOrCreateKotlinClass(Class javaClass) {
        return factory.getOrCreateKotlinClass(javaClass);
    }

    public static KClass getOrCreateKotlinClass(Class javaClass, String internalName) {
        return factory.getOrCreateKotlinClass(javaClass, internalName);
    }

    public static KClass[] getOrCreateKotlinClasses(Class[] javaClasses) {
        int size = javaClasses.length;
        if (size == 0) {
            return EMPTY_K_CLASS_ARRAY;
        }
        KClass[] kClasses = new KClass[size];
        for (int i = 0; i < size; ++i) {
            kClasses[i] = Reflection.getOrCreateKotlinClass(javaClasses[i]);
        }
        return kClasses;
    }

    @SinceKotlin(version="1.1")
    public static String renderLambdaToString(Lambda lambda2) {
        return factory.renderLambdaToString(lambda2);
    }

    @SinceKotlin(version="1.3")
    public static String renderLambdaToString(FunctionBase lambda2) {
        return factory.renderLambdaToString(lambda2);
    }

    public static KFunction function(FunctionReference f) {
        return factory.function(f);
    }

    public static KProperty0 property0(PropertyReference0 p) {
        return factory.property0(p);
    }

    public static KMutableProperty0 mutableProperty0(MutablePropertyReference0 p) {
        return factory.mutableProperty0(p);
    }

    public static KProperty1 property1(PropertyReference1 p) {
        return factory.property1(p);
    }

    public static KMutableProperty1 mutableProperty1(MutablePropertyReference1 p) {
        return factory.mutableProperty1(p);
    }

    public static KProperty2 property2(PropertyReference2 p) {
        return factory.property2(p);
    }

    public static KMutableProperty2 mutableProperty2(MutablePropertyReference2 p) {
        return factory.mutableProperty2(p);
    }

    @SinceKotlin(version="1.4")
    public static KType typeOf(Class klass) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Collections.<KTypeProjection>emptyList(), false);
    }

    @SinceKotlin(version="1.4")
    public static KType typeOf(Class klass, KTypeProjection arg1) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Collections.singletonList(arg1), false);
    }

    @SinceKotlin(version="1.4")
    public static KType typeOf(Class klass, KTypeProjection arg1, KTypeProjection arg2) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Arrays.asList(arg1, arg2), false);
    }

    @SinceKotlin(version="1.4")
    public static KType typeOf(Class klass, KTypeProjection ... arguments) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), ArraysKt.toList(arguments), false);
    }

    @SinceKotlin(version="1.4")
    public static KType nullableTypeOf(Class klass) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Collections.<KTypeProjection>emptyList(), true);
    }

    @SinceKotlin(version="1.4")
    public static KType nullableTypeOf(Class klass, KTypeProjection arg1) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Collections.singletonList(arg1), true);
    }

    @SinceKotlin(version="1.4")
    public static KType nullableTypeOf(Class klass, KTypeProjection arg1, KTypeProjection arg2) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Arrays.asList(arg1, arg2), true);
    }

    @SinceKotlin(version="1.4")
    public static KType nullableTypeOf(Class klass, KTypeProjection ... arguments) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), ArraysKt.toList(arguments), true);
    }

    static {
        ReflectionFactory impl;
        try {
            Class<?> implClass = Class.forName("codegurushadow.kotlin.reflect.jvm.internal.ReflectionFactoryImpl");
            impl = (ReflectionFactory)implClass.newInstance();
        }
        catch (ClassCastException e) {
            impl = null;
        }
        catch (ClassNotFoundException e) {
            impl = null;
        }
        catch (InstantiationException e) {
            impl = null;
        }
        catch (IllegalAccessException e) {
            impl = null;
        }
        factory = impl != null ? impl : new ReflectionFactory();
        EMPTY_K_CLASS_ARRAY = new KClass[0];
    }
}

