/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.apache.http.impl.conn;

import codegurushadow.org.apache.http.HttpException;
import codegurushadow.org.apache.http.HttpHost;
import codegurushadow.org.apache.http.HttpRequest;
import codegurushadow.org.apache.http.ProtocolException;
import codegurushadow.org.apache.http.annotation.Contract;
import codegurushadow.org.apache.http.annotation.ThreadingBehavior;
import codegurushadow.org.apache.http.client.config.RequestConfig;
import codegurushadow.org.apache.http.client.protocol.HttpClientContext;
import codegurushadow.org.apache.http.conn.SchemePortResolver;
import codegurushadow.org.apache.http.conn.UnsupportedSchemeException;
import codegurushadow.org.apache.http.conn.routing.HttpRoute;
import codegurushadow.org.apache.http.conn.routing.HttpRoutePlanner;
import codegurushadow.org.apache.http.impl.conn.DefaultSchemePortResolver;
import codegurushadow.org.apache.http.protocol.HttpContext;
import codegurushadow.org.apache.http.util.Args;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        return proxy == null ? new HttpRoute(target, local, secure) : new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

