/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.apache.http.impl.cookie;

import codegurushadow.org.apache.http.annotation.Contract;
import codegurushadow.org.apache.http.annotation.ThreadingBehavior;
import codegurushadow.org.apache.http.cookie.CommonCookieAttributeHandler;
import codegurushadow.org.apache.http.cookie.Cookie;
import codegurushadow.org.apache.http.cookie.CookieOrigin;
import codegurushadow.org.apache.http.cookie.MalformedCookieException;
import codegurushadow.org.apache.http.cookie.SetCookie;
import codegurushadow.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import codegurushadow.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

