/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.apache.http.impl.io;

import codegurushadow.org.apache.http.HttpResponse;
import codegurushadow.org.apache.http.HttpResponseFactory;
import codegurushadow.org.apache.http.annotation.Contract;
import codegurushadow.org.apache.http.annotation.ThreadingBehavior;
import codegurushadow.org.apache.http.config.MessageConstraints;
import codegurushadow.org.apache.http.impl.DefaultHttpResponseFactory;
import codegurushadow.org.apache.http.impl.io.DefaultHttpResponseParser;
import codegurushadow.org.apache.http.io.HttpMessageParser;
import codegurushadow.org.apache.http.io.HttpMessageParserFactory;
import codegurushadow.org.apache.http.io.SessionInputBuffer;
import codegurushadow.org.apache.http.message.BasicLineParser;
import codegurushadow.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

