/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.apache.http.impl.nio.codecs;

import codegurushadow.org.apache.http.HttpResponse;
import codegurushadow.org.apache.http.HttpResponseFactory;
import codegurushadow.org.apache.http.annotation.Contract;
import codegurushadow.org.apache.http.annotation.ThreadingBehavior;
import codegurushadow.org.apache.http.config.MessageConstraints;
import codegurushadow.org.apache.http.impl.DefaultHttpResponseFactory;
import codegurushadow.org.apache.http.impl.nio.codecs.DefaultHttpResponseParser;
import codegurushadow.org.apache.http.message.BasicLineParser;
import codegurushadow.org.apache.http.message.LineParser;
import codegurushadow.org.apache.http.nio.NHttpMessageParser;
import codegurushadow.org.apache.http.nio.NHttpMessageParserFactory;
import codegurushadow.org.apache.http.nio.reactor.SessionInputBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements NHttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

