/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.apache.http.impl.nio.pool;

import codegurushadow.org.apache.http.HttpHost;
import codegurushadow.org.apache.http.HttpRequest;
import codegurushadow.org.apache.http.HttpResponse;
import codegurushadow.org.apache.http.HttpResponseFactory;
import codegurushadow.org.apache.http.annotation.Contract;
import codegurushadow.org.apache.http.annotation.ThreadingBehavior;
import codegurushadow.org.apache.http.config.ConnectionConfig;
import codegurushadow.org.apache.http.impl.DefaultHttpResponseFactory;
import codegurushadow.org.apache.http.impl.nio.DefaultNHttpClientConnectionFactory;
import codegurushadow.org.apache.http.impl.nio.SSLNHttpClientConnectionFactory;
import codegurushadow.org.apache.http.nio.NHttpClientConnection;
import codegurushadow.org.apache.http.nio.NHttpConnectionFactory;
import codegurushadow.org.apache.http.nio.NHttpMessageParserFactory;
import codegurushadow.org.apache.http.nio.NHttpMessageWriterFactory;
import codegurushadow.org.apache.http.nio.pool.NIOConnFactory;
import codegurushadow.org.apache.http.nio.reactor.IOSession;
import codegurushadow.org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import codegurushadow.org.apache.http.nio.util.ByteBufferAllocator;
import codegurushadow.org.apache.http.nio.util.HeapByteBufferAllocator;
import codegurushadow.org.apache.http.params.HttpParams;
import codegurushadow.org.apache.http.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicNIOConnFactory
implements NIOConnFactory<HttpHost, NHttpClientConnection> {
    private final NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory;
    private final NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory;

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory, NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory) {
        Args.notNull(plainFactory, "Plain HTTP client connection factory");
        this.plainFactory = plainFactory;
        this.sslFactory = sslFactory;
    }

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory) {
        this(plainFactory, null);
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslContext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        this(new DefaultNHttpClientConnectionFactory(responseFactory, allocator, params), new SSLNHttpClientConnectionFactory(sslContext, sslHandler, responseFactory, allocator, params));
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslContext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslContext, sslHandler, DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    public BasicNIOConnFactory(HttpParams params) {
        this(null, null, params);
    }

    public BasicNIOConnFactory(SSLContext sslContext, SSLSetupHandler sslHandler, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(responseParserFactory, requestWriterFactory, allocator, config), new SSLNHttpClientConnectionFactory(sslContext, sslHandler, responseParserFactory, requestWriterFactory, allocator, config));
    }

    public BasicNIOConnFactory(SSLContext sslContext, SSLSetupHandler sslHandler, ConnectionConfig config) {
        this(sslContext, sslHandler, null, null, null, config);
    }

    public BasicNIOConnFactory(ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(config), null);
    }

    @Override
    public NHttpClientConnection create(HttpHost route, IOSession session) throws IOException {
        NHttpClientConnection conn;
        if (route.getSchemeName().equalsIgnoreCase("https")) {
            if (this.sslFactory == null) {
                throw new IOException("SSL not supported");
            }
            conn = this.sslFactory.createConnection(session);
        } else {
            conn = this.plainFactory.createConnection(session);
        }
        session.setAttribute("http.connection", conn);
        return conn;
    }
}

