/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.apache.http.nio.protocol;

import codegurushadow.org.apache.http.ContentTooLongException;
import codegurushadow.org.apache.http.HttpEntity;
import codegurushadow.org.apache.http.HttpEntityEnclosingRequest;
import codegurushadow.org.apache.http.HttpRequest;
import codegurushadow.org.apache.http.entity.ContentType;
import codegurushadow.org.apache.http.nio.ContentDecoder;
import codegurushadow.org.apache.http.nio.IOControl;
import codegurushadow.org.apache.http.nio.entity.ContentBufferEntity;
import codegurushadow.org.apache.http.nio.protocol.AbstractAsyncRequestConsumer;
import codegurushadow.org.apache.http.nio.util.HeapByteBufferAllocator;
import codegurushadow.org.apache.http.nio.util.SimpleInputBuffer;
import codegurushadow.org.apache.http.protocol.HttpContext;
import codegurushadow.org.apache.http.util.Asserts;
import java.io.IOException;

public class BasicAsyncRequestConsumer
extends AbstractAsyncRequestConsumer<HttpRequest> {
    private static final int MAX_INITIAL_BUFFER_SIZE = 262144;
    private volatile HttpRequest request;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onRequestReceived(HttpRequest request) throws IOException {
        this.request = request;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: %,d", len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        int initialBufferSize = Math.min((int)len, 262144);
        this.buf = new SimpleInputBuffer(initialBufferSize, new HeapByteBufferAllocator());
        ((HttpEntityEnclosingRequest)this.request).setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder2, IOControl ioControl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder2);
    }

    @Override
    protected void releaseResources() {
        this.request = null;
        this.buf = null;
    }

    @Override
    protected HttpRequest buildResult(HttpContext context) {
        return this.request;
    }
}

