/*
 * Decompiled with CFR 0.152.
 */
package codegurushadow.org.apache.http.nio.util;

import codegurushadow.org.apache.http.annotation.Contract;
import codegurushadow.org.apache.http.annotation.ThreadingBehavior;
import codegurushadow.org.apache.http.nio.ContentDecoder;
import codegurushadow.org.apache.http.nio.IOControl;
import codegurushadow.org.apache.http.nio.util.ByteBufferAllocator;
import codegurushadow.org.apache.http.nio.util.ContentInputBuffer;
import codegurushadow.org.apache.http.nio.util.ExpandableBuffer;
import codegurushadow.org.apache.http.nio.util.HeapByteBufferAllocator;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class SharedInputBuffer
extends ExpandableBuffer
implements ContentInputBuffer {
    private final ReentrantLock lock;
    private final Condition condition;
    private volatile IOControl ioControl;
    private volatile boolean shutdown = false;
    private volatile boolean endOfStream = false;

    @Deprecated
    public SharedInputBuffer(int bufferSize, IOControl ioControl, ByteBufferAllocator allocator) {
        super(bufferSize, allocator);
        this.ioControl = ioControl;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public SharedInputBuffer(int bufferSize, ByteBufferAllocator allocator) {
        super(bufferSize, allocator);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public SharedInputBuffer(int bufferSize) {
        this(bufferSize, HeapByteBufferAllocator.INSTANCE);
    }

    @Override
    public void reset() {
        if (this.shutdown) {
            return;
        }
        this.lock.lock();
        try {
            this.clear();
            this.endOfStream = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Deprecated
    public int consumeContent(ContentDecoder decoder2) throws IOException {
        return this.consumeContent(decoder2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int consumeContent(ContentDecoder decoder2, IOControl ioControl) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        this.lock.lock();
        try {
            int bytesRead;
            if (ioControl != null) {
                this.ioControl = ioControl;
            }
            this.setInputMode();
            int totalRead = 0;
            while ((bytesRead = decoder2.read(this.buffer)) > 0) {
                totalRead += bytesRead;
            }
            if (bytesRead == -1 || decoder2.isCompleted()) {
                this.endOfStream = true;
            }
            if (!this.buffer.hasRemaining() && this.ioControl != null) {
                this.ioControl.suspendInput();
            }
            this.condition.signalAll();
            if (totalRead > 0) {
                int n = totalRead;
                return n;
            }
            int n = this.endOfStream ? -1 : 0;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasData() {
        this.lock.lock();
        try {
            boolean bl = super.hasData();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int available() {
        this.lock.lock();
        try {
            int n = super.available();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int capacity() {
        this.lock.lock();
        try {
            int n = super.capacity();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int length() {
        this.lock.lock();
        try {
            int n = super.length();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void waitForData() throws IOException {
        this.lock.lock();
        try {
            try {
                while (!super.hasData() && !this.endOfStream) {
                    if (this.shutdown) {
                        throw new InterruptedIOException("Input operation aborted");
                    }
                    if (this.ioControl != null) {
                        this.ioControl.requestInput();
                    }
                    this.condition.await();
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Interrupted while waiting for more data");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        if (this.shutdown) {
            return;
        }
        this.endOfStream = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    protected boolean isEndOfStream() {
        return this.shutdown || !this.hasData() && this.endOfStream;
    }

    @Override
    public int read() throws IOException {
        if (this.shutdown) {
            return -1;
        }
        this.lock.lock();
        try {
            if (!this.hasData()) {
                this.waitForData();
            }
            if (this.isEndOfStream()) {
                int n = -1;
                return n;
            }
            int n = this.buffer.get() & 0xFF;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (b == null) {
            return 0;
        }
        this.lock.lock();
        try {
            if (!this.hasData()) {
                this.waitForData();
            }
            if (this.isEndOfStream()) {
                int n = -1;
                return n;
            }
            this.setOutputMode();
            int chunk = len;
            if (chunk > this.buffer.remaining()) {
                chunk = this.buffer.remaining();
            }
            this.buffer.get(b, off, chunk);
            int n = chunk;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int read(byte[] b) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (b == null) {
            return 0;
        }
        return this.read(b, 0, b.length);
    }
}

